<?php
namespace App\Channels;

use Illuminate\Notifications\Notification;
use Kreait\Firebase\Messaging\CloudMessage;
use Kreait\Firebase\Messaging\Notification as FirebaseNotification;
use Kreait\Firebase\Factory;
use Illuminate\Support\Facades\Log;

class FirebaseChannel
{
    /**
     * Send the notification via Firebase
     *
     * @param mixed $notifiable
     * @param Notification $notification
     * @return void
     */
    public function send($notifiable, Notification $notification)
    {
        // Get the notification data for Firebase (typically 'title' and 'body')
        $notifications = $notification->toArray($notifiable);

        // Ensure the FCM token is present
        $fcms = $notifiable->fcm_token;

        if (!$fcms) {
            // Handle missing token, e.g., log an error, throw an exception, etc.
            Log::error('FCM token not found for the notifiable.');
            throw new \Exception('FCM token not found for the notifiable.');
        }

        // Initialize Firebase Messaging
        // $messaging = (new Factory)
        //     ->withServiceAccount(public_path('firebase/zajel-24d37-firebase-adminsdk-j79vx-74646ffbdb.json'))  // Path to service account credentials
        //     ->createMessaging();

        // // Create the CloudMessage with the notification and data
        // $firebaseNotification = FirebaseNotification::create($data['title'], $data['body']);
        // $message = CloudMessage::new()
        //     ->withNotification($firebaseNotification)
        //     ->withData($data);  // Attach any additional data to the message

        try {
            // Send the message to the device with the FCM token
            // $messaging->send($message, $fcmToken);



            $deviceTokens = is_array($fcms) ? $fcms : [$fcms];
            $message = CloudMessage::new();

            // $notification = Notification::fromArray([
            //     'title' => $data['title'],
            //     'body' =>  $data['body'],
            // ]);
            $message = $message->withNotification($notifications);
            $data=[]
            $message = $message->withData($data);

            $sendReport = $this->messaging->sendMulticast($message, $deviceTokens);



        } catch (\Exception $e) {
            // Log any errors that occur during sending
            Log::error('Failed to send Firebase notification: ' . $e->getMessage());
        }
    }
}
