<?php

namespace App\Exports;

use App\Models\ContestStudent;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class ContestStudentsExport implements FromQuery, WithHeadings, WithMapping
{
    protected $search;
    protected $searchContestId;

    /**
     * Constructor to accept search parameters
     */
    public function __construct($search = null, $searchContestId = null)
    {
        $this->search = $search;
        $this->searchContestId = $searchContestId;
    }

    /**
     * Query to fetch the data
     */
    public function query()
    {
        return ContestStudent::query()
            ->with(['students', 'contests'])
            ->when($this->search, function ($q) {
                $q->whereHas('students', function ($query) {
                    $query->where('name', 'like', '%' . $this->search . '%')
                          ->orWhere('id_number', 'like', '%' . $this->search . '%');
                })->orWhereHas('contests', function ($query) {
                    $query->where('name', 'like', '%' . $this->search . '%');
                });
            })
            ->when($this->searchContestId, function ($q) {
                if ($this->searchContestId != -1) {
                    $q->where('contest_id', $this->searchContestId);
                }
            });
    }

    /**
     * Define headings for Excel file
     */
    public function headings(): array
    {
        return [
            'Student Name',
            'ID Number',
            'Mobile',
            'Level',
            'Class Room',
            'Schools',
            'Contest Name',
            'Mark',

        ];
    }

    /**
     * Map the data for each row
     */
    public function map($row): array
    {
        return [
            $row->students?->name ?? 'N/A',
            $row->students?->id_number ?? 'N/A',
            $row->students?->mobile ?? 'N/A',
            $row->students?->levels?->name ?? 'N/A',
            $row->students?->classRooms?->name ?? 'N/A',
            $row->students?->school?->name ?? 'N/A',
            $row->contests?->name ?? 'N/A',
            $row->mark ?? 'N/A',

        ];
    }
}
