<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class ErrorSchoolExportExeclSheet implements FromArray, WithHeadings, WithMapping
{
    protected $failedRows;

    public function __construct(array $failedRows)
    {
        $this->failedRows = $failedRows;
    }

    // Return the failed rows as an array
    public function array(): array
    {
        return $this->failedRows;
    }

    // Add headings for the columns
    public function headings(): array
    {
        return [
            'Education Area Name',
            'School Name',
            'Errors' // Add heading for the Errors column
        ];
    }

    // Map each row and inject the error messages into the appropriate cell
    public function map($row): array
    {
        // dd($row);
        $values = $row['values'];
        $errors = $row['errors'];

        // Collect all error messages for this row
        $errorMessages = [];
        foreach ($errors as $attribute => $error) {
            // Assuming errors are arrays, collect them as a string
            if (is_array($error)) {
                $errorMessages[] = implode(', ', $error);
            } else {
                $errorMessages[] = $error; // Handle case where error is a string
            }
        }


        // Return the row data and the error messages in the last column
        return [
            $values['education_area_name'] ?? '',
            $values['school_name'] ?? '',
            implode(' | ', $errorMessages) // Add errors as a single string in the "Errors" column
        ];
    }
}

