<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class ErrorStudenntExportExeclSheet implements FromArray, WithHeadings, WithMapping
{
    protected $failedRows;

    public function __construct(array $failedRows)
    {
        $this->failedRows = $failedRows;
    }

    // Return the failed rows as an array
    public function array(): array
    {
        return $this->failedRows;
    }

    // Add headings for the columns
    public function headings(): array
    {
        return [
            'Name',
            'Id Number',
            'Governorate Name',
            'School Name',
            'Classroom Name',
            'Level Code',
            'password',
            'Mobile',
            'Errors' // Add heading for the Errors column
        ];
    }

    // Map each row and inject the error messages into the appropriate cell
    public function map($row): array
    {

        $values = $row['values'] ?? ($row->values ?? []);
        $errors = $row['errors'] ?? ($row->errors ?? []);

        $errorMessages = array_map(function ($error) {
            return is_array($error) ? implode(', ', $error) : $error;
        }, $errors);


        // Return the row data and the error messages in the last column
        return [
            $values['name'] ?? '',
            $values['id_number'] ?? '',
            $values['governorate_name'] ?? '',
            $values['school_name'] ?? '',
            $values['classroom_name'] ?? '',
            $values['level_code'] ?? '',
            $values['password'] ?? '',
            $values['mobile'] ?? '',

            implode(' | ', $errorMessages) // Add errors as a single string in the "Errors" column
        ];
    }
}
