<?php

namespace App\Http\Controllers\Api\Contest;

use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Contest\ContestFinshRequest;
use App\Http\Requests\Api\Contest\ContestRequest;
use App\Http\Requests\Api\Contests\SingleContest;
use App\Http\Requests\Api\Contests\SingleRequest;
use App\Http\Resources\ContestResource;
use App\Models\Contest;
use App\Models\ContestQuestion;
use App\Models\ContestStudent;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class ContestController extends Controller
{

    public function index(Request $request)
    {

        $name = $request->level_name;
        $contests = Contest::query()
            ->whereHas('levels', function ($q) use ($name) {
                $q->where('name', $name);
            })
            ->with([
                'illustrations',
                'questions',
                'questionsWithoutIllustrations',
            ])
            ->get();
        $response['data'] = ContestResource::collection($contests);
        return response_api(true, 'نجاح العملية', $response, 200);
    }


    public function SingleContest(SingleContest $request)
    {
        $contest = Contest::query()
        ->with([
            'illustrations',
            'questions',
            'questionsWithoutIllustrations',
        ])
        ->where('id', $request->contest_id)->first();

        $response['data'] = new ContestResource($contest);
        return response_api(true, 'نجاح العملية', $response, 200);
    }

    public function CheckDataContest(SingleRequest $request)
    {
        $contest = Contest::query()
        ->with([
            'illustrations',
            'questions',
            'questionsWithoutIllustrations',
        ])
        ->where('id', $request->contest_id)->first();

        if(!$contest){
            return response_api(false, 'Contest not found', [], 404);
        }

        if(!$contest->correct_code){



        if (auth('sanctum')->user()->code != $request->code) {
            $error['error'] = ['The contest is not available'];
            return response_api(false, $error, [], 422);
        }

        if (!Hash::check($request->password, auth('sanctum')->user()->password)) {
            $error['error'] = ['Password is incorrect'];
            return response_api(false, $error, [], 422);
        }
    }
        $contest->update([
            'correct_code' => 1,
        ]);
        $response['data'] = new ContestResource($contest);
        return response_api(true, 'نجاح العملية', $response, 200);
    }

    public function finshContest(ContestFinshRequest $request)
    {
        $contest = Contest::query()->where('id', $request->contest_id)->first();

        if (!$contest) {
            return response_api(false, 'Contest not found', [], 404);
        }

        // Check if the student has already participated in the contest
        $existingParticipation = $contest->students()->where('student_id', auth('sanctum')->id())->exists();

        if ($existingParticipation) {
            $error['error'] = ['You have already participated in this contest'];
            return response_api(false,  $error, [], 422);
        }

        $questions = ContestQuestion::where('contest_id', $request->contest_id)->get();
        // Calculate the total score based on marks
        $totalScore = 0;

        foreach ($questions as $question) {
            // Check if the answer is correct (assuming 'is_correct' is a field)
            $correctAnswer = $question->answers()->where('is_correct', 1)->first();

            // Add the mark to the total if the answer is correct
            if ($correctAnswer) {
                $totalScore += $question->mark;
            }
        }

        $userScore = 0;
        foreach ($request->answers as $answerData) {
            // Get the contest question by its ID
            $question = ContestQuestion::find($answerData['question_id']);

            if ($question) {
                // Retrieve the correct answer for this question
                $correctAnswer = $question->answers()->where('is_correct', 1)->first();

                // Check if the provided answer matches the correct answer
                if ($correctAnswer && $correctAnswer->id == $answerData['answer_id']) {
                    // Add the mark for the question if the answer is correct
                    $userScore += $question->mark;
                }
            }
        }

        $mark = $totalScore . '/' . $userScore;

        ContestStudent::query()->create([
            'student_id' => auth('sanctum')->id(),
            'contest_id' => $contest->id,
            'mark' => $mark,
        ]);


        $response['data'] = [
            'result' => $mark,
        ];

        return response_api(true, 'نجاح العملية', $response, 200);
    }
}
