<?php

namespace App\Http\Controllers\Api\Lessons;

use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Student\Lessons\MarkLessonRequest;
use App\Http\Requests\Api\Student\Lessons\WatchLessonRequest;

class LessonController extends Controller
{
    // Watch a lesson
    public function watch(WatchLessonRequest $request)
    {



        $user = auth('sanctum')->user();
        $lessonId = $request->lesson_id;

        if (!$user->watchLessons()->where('lesson_id', $lessonId)->exists()) {
            $user->watchLessons()->attach($lessonId);
        }
        return response_api(true, 'نجاح العملية', ['data' => null], 201);
    }

    // Mark a lesson
    public function markLessons(MarkLessonRequest $request)
    {
        auth('sanctum')->user()->markLessons()->attach($request->lessonId,['mark'=>$request->mark]);
        return response_api(true, 'نجاح العملية', ['data' => null], 201);

        // return $this->handleLessonAction($request->lesson_id, 'markLessons', 'تم تقييم الدرس من قبل');
    }

    // Private method to handle both watching and marking lessons
    private function handleLessonAction($lessonId, $relationMethod, $errorMessage)
    {
        $user = auth('sanctum')->user();

        // Check if the lesson has already been watched or marked
//         $existingLesson = $user->$relationMethod()->where('lesson_id', $lessonId)->first();

// //        if ($existingLesson) {
// //            $error =  [$errorMessage];
// //            return response_api(true, $error, ['data' => []], 422);
// //        }

        // Attach the lesson

        // Return success response
        return response_api(true, 'نجاح العملية', ['data' => null], 201);
    }
}
