<?php

namespace App\Http\Controllers\Api\SchoolMangments;

use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Student\ClassRoom\ClassRoomRequest;
use App\Http\Resources\ClassRoomResource;
use App\Http\Resources\SingleClassRoomResource;
use App\Http\Resources\SubjectsResource;
use App\Models\ClassRoom;
use App\Models\Material;
use Illuminate\Http\Request;

class SchoolController extends Controller
{
    //

    public  function getClassRoom(){
        $class_rooms=ClassRoom::query()->get();


        $response['data']=SingleClassRoomResource::collection($class_rooms);
        return response_api(true ,'نجاح العملية',$response,200);


    }
    public  function  index(ClassRoomRequest $request){

        $class_rooms=ClassRoom::query()->where('name',$request->class_room)->first();

       $material =Material::query()->whereHas('classRooms',function ($q)use($class_rooms){
           $q->where('id',$class_rooms->id);
        })->get();

        $storagePath = storage_path('app/public/'.$class_rooms->code); // Specify the directory you want to check
        $size =$this->get_directory_size($storagePath);
        $response['data']['year']['id']=$class_rooms->id;
        $response['data']['year']['name']=$class_rooms->name;
        $response['data']['file_size']=$size;

        $response['data']['subjects']=SubjectsResource::collection($material);
        return response_api(true ,'نجاح العملية',$response,200);
    }



    public  function get_directory_size($dir) {
        $size = 0;

        // Check if the directory exists
        if (is_dir($dir)) {
            // Create a recursive directory iterator
            $iterator = new \RecursiveIteratorIterator(new \RecursiveDirectoryIterator($dir));

            foreach ($iterator as $file) {
                // Skip directories (they can be counted separately, if needed)
                if (!$file->isDir()) {
                    $size += $file->getSize(); // Add file size to total
                }
            }
        }

        return $this->format_size($size);
    }

    function format_size($bytes, $decimals = 2) {
        $sizes = ['B', 'KB', 'MB', 'GB', 'TB'];
        $factor = floor((strlen($bytes) - 1) / 3); // Calculate factor for size conversion
        return sprintf("%.{$decimals}f", $bytes / pow(1024, $factor)) . ' ' . @$sizes[$factor];
    }
}
