<?php

namespace App\Http\Controllers\Api\Student;

use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Student\AuthRequest;
use App\Http\Requests\Api\Student\RegisterRequest;
use App\Http\Resources\StudentProfileResource;
use App\Http\Resources\StudentResource;
use App\Models\Student;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class AuthController extends Controller
{
    //

    public  function  login(AuthRequest $request)
    {

        $student = Student::query()->where('id_number', $request->id_number)->first();

        if(!$student){

            $error['message']=['الطالب غير موجود لدينا'];
            $response['data']=null;
            return response_api(true, $error, $response, 422);

        }


        if (!$student || !Hash::check($request->password, $student->password)) {
            $error['message']=['هناك خطا في البيانات المدخلة'];
            $response['data']=null;
            return response_api(true, $error, $response, 422);

        }
        $student->update([
            'is_active' => 1,
            'fcm_token' => $request->fcm_token,
        ]);
        $student->plainTextToken = $student->createToken('student-token')->plainTextToken;
        $response['data'] = new StudentProfileResource($student);

        return response_api(true, __('message.successFull'), $response, 201);
    }

    public function register(RegisterRequest $request)
    {

        $student = Student::query()->create([
            'name' => $request->name,
            'class_room_id' => $request->class_room_id,
            'id_number' => $request->id_number,
            'fcm_token' => $request->fcm_token,
            'is_active'=>1,
        ]);

        $student->plainTextToken = $student->createToken('student-token')->plainTextToken;

        $response['data'] = new StudentProfileResource($student);

        return response_api(true, __('message.successFull'), $response, 201);
    }

    public function logout(Request $request)
    {



        // Revoke the token that was used to authenticate the current request
        $request->user()->currentAccessToken()->delete();
        $response['data'] = null;
        return response_api(true, __('message.successfully_process'), $response, 201);

    }

    public function deleteAccount(){
        $student = auth()->user();
        $student->delete();
        $response['data'] = null;
        return response_api(true, __('message.successfully_process'), $response, 201);
    }
}
