<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\Auth\LoginRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Yoeunes\Toastr\Facades\Toastr;

class AuthController extends Controller
{
    //

    public  function  showLoginForm(){

        return view('auth.login');
    }

    public  function login(LoginRequest $request){
        $credentials = $request->only('email', 'password');

        // Attempt to log the user in
        if (Auth::guard('admin')->attempt($credentials)) {
            // Authentication passed
            Toastr::success('Welcome back!', 'Login Successful');
            return redirect()->intended('/');  // Redirect to intended page or dashboard
        } else {
            // Authentication failed
            Toastr::error('Invalid email or password.', 'Login Failed');
            return redirect()->back()->withInput();  // Redirect back with input to preserve the entered email
        }
    }

    public  function  logout(){
        // dd('asas');
// return 1;
        auth('admin')->logout();
        request()->session()->invalidate();

        // // Regenerate the session token to prevent CSRF attacks
        request()->session()->regenerateToken();
         return redirect()->route('login');

    }
}


