<?php

namespace App\Http\Controllers\Dashboard\Achievements;

use App\Exports\ContestStudentsExport;
use App\Http\Controllers\Controller;
use App\Models\Achievement;
use App\Models\Contest;
use App\Models\ContestStudent;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;
use Yajra\DataTables\Facades\DataTables;

class AchievementController extends Controller
{
    //

    public function index()
    {

        $data['contests'] = Contest::all();
        return view('dashboard.achievements.index', $data);
    }


    public function getIndex(Request $request)
    {
        $search = $request->search['value'] ?? false;
        $query = ContestStudent::query()
            ->with(['students', 'contests']) // Load relationships
            ->select('contest_students.*')  // Select columns from contest_students explicitly
            ->when($search, function ($q) use ($search) {
                $q->whereHas('students', function ($query) use ($search) {
                    $query->where('name', 'like', '%' . $search . '%')
                        ->orWhere('id_number', 'like', '%' . $search . '%');
                })->orWhereHas('contests', function ($query) use ($search) {
                    $query->where('name', 'like', '%' . $search . '%');
                });
            })->when($search, function ($q) use ($search) {
                $q->where('name', 'like', '%' . $search . '%');
            })->when($search_contest_id ?? null, function ($q, $search_contest_id) {
                if ($search_contest_id != -1) $q->where('contest_id', $search_contest_id);
            });


        if ($request->has('order')) {
            $columnIndex = $request->input('order.0.column'); // Column index
            $direction = $request->input('order.0.dir'); // asc or desc
            $columns = [
                'contest_students.id', // Fully qualify 'id'
                'students.name',
                'students.id_number',
                'contests.name',
            ];

            if (isset($columns[$columnIndex])) {
                $query->orderBy($columns[$columnIndex], $direction);
            }
        }
        return DataTables::of($query)
            ->addColumn('student_name', function ($data) {
                return $data->students?->name ?? 'N/A'; // Ensure 'students' relationship is loaded
            })
            ->addColumn('id_number', function ($data) {
                return $data->students?->id_number ?? 'N/A'; // Ensure 'students' relationship is loaded
            })
            ->addColumn('contest_name', function ($data) {
                return $data->contests?->name ?? 'N/A'; // Ensure 'contests' relationship is loaded
            })
            ->addColumn('actions', function ($data) {
                // Return action buttons if needed
                return view('dashboard.achievements.partials.actions', compact('data'));
            })
            ->rawColumns(['actions']) // Allow raw HTML for specific columns
            ->make(true);
    }


    public function delete(Request $request)
    {
        Achievement::where('id', $request->id)->first();
        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنجاح',
        ]);
    }

    public function exportToExcel(Request $request)
    {
        $search = $request->input('search', null);
        $searchContestId = $request->input('search_contest_id', null);

        // Generate the Excel file
        $fileName = 'contest_students_' . date('Y_m_d_H_i_s') . '.xlsx';
        return Excel::download(new ContestStudentsExport($search, $searchContestId), $fileName);
    }
}
