<?php

namespace App\Http\Controllers\Dashboard\Admins;

use App\Http\Controllers\Controller;
use App\Http\Requests\Dashboard\Admins\AdminRequest;
use App\Models\Admin;
use App\Models\Role;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Yajra\DataTables\Facades\DataTables;

class AdminController extends Controller
{
    public function index(Request $request)
    {
        $data['modal'] = $request->modal;
        $data['roles'] = Role::query()->get();
        return view('dashboard.admins.index', $data); // Load the view for DataTable
    }

    public function getIndex(Request $request)
    {
        $search = $request->search['value'] ?? null;
        $query = Admin::with('roles')
            ->when($search, fn($q) => $q->where('name', 'like', "%$search%"));

        if ($request->has('order')) {
            $columns = ['id', 'name'];
            $columnIndex = $request->input('order.0.column');
            $direction = $request->input('order.0.dir');

            if (isset($columns[$columnIndex])) {
                $query->orderBy($columns[$columnIndex], $direction);
            }
        }

        return DataTables::of($query)
            ->addColumn('actions', fn($data) => view('dashboard.admins.partials.actions', compact('data')))
            ->rawColumns(['actions'])
            ->make(true);
    }



    public function store(AdminRequest $request)
    {
        $data = $request->except(['admin_id', 'password', '_token']);
        $data['password'] = Hash::make($request->password);

        Admin::create($data);

        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنجاح',
        ]);
    }

    public function update(Request $request)
    {
        $data = $request->except(['admin_id', 'password', '_token']);

        Admin::where('id', $request->admin_id)->update($data);

        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنجاح',
        ]);
    }

    public function delete(Request $request)
    {
        Admin::where('id', $request->id)->delete();

        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنجاح',
        ]);
    }

}
