<?php

namespace App\Http\Controllers\Dashboard\ClassRooms;

use App\Http\Controllers\Controller;
use App\Models\ClassRoom;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class ClassRoomController extends Controller
{
    public function index(Request $request)
    {
        // Pass modal data to view if it exists
        $data['modal'] = $request->modal;
        return view('dashboard.classRooms.index', $data); // Return DataTable view
    }

    public function getIndex(Request $request)
    {
        // Search functionality
        $search = $request->search['value'] ?? false;
        $query = ClassRoom::query()
            ->when($search, function ($q) use ($search) {
                $q->where('name', 'like', '%' . $search . '%');
            });

        // Sorting functionality
        if ($request->has('order')) {
            $columnIndex = $request->input('order.0.column');
            $direction = $request->input('order.0.dir');
            $columns = ['id', 'name']; // Sortable columns

            // Apply sorting if valid
            if (isset($columns[$columnIndex])) {
                $query->orderBy($columns[$columnIndex], $direction);
            }
        }

        // Return DataTables response
        return DataTables::of($query)
            ->addColumn('actions', function ($data) {
                return view('dashboard.classRooms.partials.actions', compact('data')); // Render actions view
            })
            ->rawColumns(['actions']) // Ensure actions are rendered as raw HTML
            ->make(true);
    }

    public function store(Request $request)
    {
        // Validate the request
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'code'=>'required'
        ]);

        // Create new ClassRoom
        ClassRoom::create($validated);

        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنجاح', // Success message
        ]);
    }

    public function update(Request $request)
    {
        // Validate the request
        $validated = $request->validate([
            'class_room_id' => 'required|exists:class_rooms,id',
            'name' => 'required|string|max:255',
            'code'=>'required'

            // Add other necessary fields and validation rules
        ]);

        unset($validated['class_room_id']);

        $classRoom = ClassRoom::findOrFail($request->class_room_id);
        $classRoom->update($validated);

        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنجاح', // Success message
        ]);
    }

    public function delete(Request $request)
    {
        // Validate the request
        $validated = $request->validate([
            'id' => 'required|exists:class_rooms,id',
        ]);

        // Find and delete the ClassRoom
        ClassRoom::findOrFail($validated['id'])->delete();

        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنجاح', // Success message
        ]);
    }
}
