<?php

namespace App\Http\Controllers\Dashboard\Contests;

use App\Exports\ErrorContestQuestionxportExeclSheet;
use App\Http\Controllers\Controller;
use App\Imports\ContestQuestionsImportExeclSheet;
use App\Models\Answer;
use App\Models\Contest;
use App\Models\ContestAnswer;
use App\Models\ContestQuestion;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Maatwebsite\Excel\Facades\Excel;
use Yajra\DataTables\Facades\DataTables;

class ContestQuestionsController extends Controller
{
    public function index(Request $request)
    {
        $data['modal'] = $request->modal;
        $data['contests']=Contest::query()->get();
        return view('dashboard.contestQuestions.index', $data); // Load the view for DataTable
    }

    public function getIndex(Request $request)
    {

        $search_contest_id=$request->search_contest_id??false;
        $search = $request->search['value']??false;
            $query = ContestQuestion::query()
            ->whereHas('contests')
                ->when($search, function ($q) use ($search) {
                    $q->where('name', 'like', '%' . $search . '%');
                })  ->when($search_contest_id ?? null, function ($q, $search_contest_id) {
                    if ($search_contest_id != -1) $q->where('contest_id', $search_contest_id);
                });

            // Sort based on the column name from DataTables
            if ($request->has('order')) {

                $columnIndex = $request->input('order.0.column'); // Get the index of the column to sort
                $direction = $request->input('order.0.dir'); // Get the sort direction (asc or desc)
                $columns = ['id', 'name']; // List of sortable columns

                // Validate and apply the sort
                if (isset($columns[$columnIndex])) {
                    $query->orderBy($columns[$columnIndex], $direction);
                }
            }


            return DataTables::of($query)



            ->addColumn('contests', fn($data) => $data->contests?->name)




                ->addColumn('actions', function ($data) {

                    return view('dashboard.contestQuestions.partials.actions',compact('data'));
                })
                ->rawColumns(['actions'])
                ->make(true);
        // }

        return response()->json(['error' => 'Invalid request'], 400);
    }


    public function store(Request $request)
    {
        $contest = Contest::findOrFail($request->contest_id);
        $question = ContestQuestion::create([
            'contest_id' => $contest->id,
            'name' => $request->name,
            'questions' => $request->question,
            'mark' => $request->mark,
        ]);

        foreach ($request->answers as $answerData) {
            if ($answerData['answer']) {
                ContestAnswer::create([
                    'answer' => $answerData['answer'],
                    'question_contest_id' => $question->id,
                    'is_correct' =>  isset($answerData['is_correct']) ?1: 0,
                ]);
            }
        }

        $correctAnswer = $question->answers()->where('is_correct', 1)->first();
        $question->update(['is_correct' => $correctAnswer?->id]);

        if ($request->question_attachment) {
            $attachment = $request->question_attachment->store("contests/{$contest->id}", 'public');
            $question->update(['attachment' => $attachment]);
        }

        $contest->update(['question_count' => $contest->questions()->count()]);

        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنجاح',
        ]);



        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنحاح',
        ]);
    }

    public function update(Request $request)
    {
        $request->validate([
            'contest_question_id' => 'required|exists:contest_questions,id',
            'name' => 'required|string|max:255',
            'mark' => 'required|integer|min:1',
            'contest_id' => 'required|exists:contests,id',
            'answers.*.answer' => 'required|string|max:255',
            'question_attachment' => 'nullable|file|mimes:jpeg,png,jpg,gif,svg,pdf|max:2048',
        ]);

        // Retrieve the question and contest
        $question = ContestQuestion::findOrFail($request->contest_question_id);
        $contest = Contest::findOrFail($request->contest_id);

        ContestAnswer::query()->where('question_contest_id', $question->id)->delete();
        $question->update([
            'contest_id' => $contest->id,
            'name' => $request->name,
            'mark' => $request->mark,
        ]);

        foreach ($request->answers as $key => $answerData) {

                    ContestAnswer::create([
                        'answer' => $answerData['answer'],
                        'question_contest_id' => $question->id,
                        'is_correct' => isset($answerData['is_correct']) ? 1 : 0,
                    ]);

            }
        



        // Update the is_correct field in the question
        $correctAnswer = $question->answers()->where('is_correct', 1)->first();
        $question->update(['is_correct' => $correctAnswer?->id]);

        // Handle question attachment
        if ($request->hasFile('question_attachment')) {
            // Delete the old file if it exists
            if ($question->attachment) {
                Storage::disk('public')->delete($question->attachment);
            }

            // Store the new file
            $attachment = $request->file('question_attachment')->store("contests/{$contest->id}", 'public');
            $question->update(['attachment' => $attachment]);
        }

        // Update contest question count
        $contest->update(['question_count' => $contest->questions()->count()]);

        return response()->json([
            'success' => true,
            'message' => 'تم تحديث السؤال بنجاح',
        ]);
    }



    public  function  delete(Request $request)
    {


        ContestQuestion::query()->where('id', $request->id)->delete();
        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنحاح',
        ]);
    }
    public function uploadExcel(Request $request)
    {
        // dd($request);
        // Validate the uploaded file
        $request->validate([
            'excel_file' => 'required|mimes:xlsx,xls',
        ]);

        try {
            $import = new ContestQuestionsImportExeclSheet();
            Excel::import($import, $request->file('excel_file'));

            // Check if there are row-specific errors
            if ($import->getErrors()) {
                // Export the errors
                $fileName = 'upload_errors_' . now()->timestamp . '.xlsx';
                $filePath = storage_path('app/public/' . $fileName);

                Excel::store(new ErrorContestQuestionxportExeclSheet($import->getErrors()), 'public/' . $fileName);

                // Generate a download URL
                $downloadUrl = asset('storage/' . $fileName);

                return response()->json([
                    'success' => false,
                    'message' => 'File download available.',
                    'download_url' => $downloadUrl,
                ]);

            }

            return response()->json([
                'success' => true,
                'message' => 'File uploaded successfully',
            ]);
        } catch (\Maatwebsite\Excel\Validators\ValidationException $e) {
            // Catch validation errors from Excel rows
            return response()->json([
                'success' => false,
                'message' => 'Validation errors occurred during import.',
                'errors' => $e->failures(), // Return validation errors
            ]);
        } catch (\Exception $e) {
            return $e;
            return response()->json([
                'success' => false,
                'message' => 'An error occurred while processing the file.',
            ]);
        }

    }
}
