<?php

namespace App\Http\Controllers\Dashboard\ContestsModels;

use App\Http\Controllers\Controller;
use App\Models\Contest;
use App\Models\Contestmodel;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class ContestsController extends Controller
{
    public function index(Request $request)
    {
        $data['modal'] = $request->modal;
        $data['contests']=Contest::query()->get();
        return view('dashboard.contestModels.index', $data); // Load the view for DataTable
    }

    public function getIndex(Request $request)
    {

        $search_contest_id=$request->search_contest_id??false;
        $search = $request->search['value']??false;
            $query = Contestmodel::query()

                ->when($search, function ($q) use ($search) {
                    $q->where('title', 'like', '%' . $search . '%');
                }) ->when($search_contest_id ?? null, function ($q, $search_contest_id) {
                    if ($search_contest_id != -1) $q->where('contest_id', $search_contest_id);
                });

            // Sort based on the column name from DataTables
            if ($request->has('order')) {

                $columnIndex = $request->input('order.0.column'); // Get the index of the column to sort
                $direction = $request->input('order.0.dir'); // Get the sort direction (asc or desc)
                $columns = ['id', 'title']; // List of sortable columns

                // Validate and apply the sort
                if (isset($columns[$columnIndex])) {
                    $query->orderBy($columns[$columnIndex], $direction);
                }
            }


            return DataTables::of($query)



            ->addColumn('contests', fn($data) => $data->contests?->name)



            ->addColumn('attachment', function ($data) {

                return view('dashboard.contestModels.partials.attachment',compact('data'));
            })

                ->addColumn('actions', function ($data) {

                    return view('dashboard.contestModels.partials.actions',compact('data'));
                })
                ->rawColumns(['actions'])
                ->make(true);
        // }

        return response()->json(['error' => 'Invalid request'], 400);
    }


    public function store(Request $request)
    {



        $attachment = '';
        $data = $request->except(['attachment_book', '_token','contest_model_id']);
        $contest =    Contest::query()->where('id', $request->contest_id)->first();

        if ($request->attachment_book) {

            $destinationPath = 'contests/'.$contest->id; // Append the file name only
            $attachment = $request->attachment_book->store($destinationPath, 'public');
        }

        Contestmodel::query()->create([
            'contest_id' => $contest->id,
            'pdf_url' => $attachment,
            'title'=>$request->title,
        ]);



        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنحاح',
        ]);
    }

    public  function  update(Request $request)
    {
        $data = $request->except(['contest_model_id','_token','attachment_book']);


        if ($request->attachment_book) {
            $contest =    Contest::query()->where('id', $request->contest_id)->first();

            $destinationPath = 'contests/'.$contest->id; // Append the file name only
            $attachment = $request->attachment_book->store($destinationPath, 'public');

            $data['pdf_url']=$attachment;
        }

        Contestmodel::query()->where('id', $request->contest_model_id)->update($data);

        // Return a successful response with the created company data
        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنحاح',
        ]);
    }


    public  function  delete(Request $request)
    {


        Contestmodel::query()->where('id', $request->id)->delete();
        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنحاح',
        ]);
    }
}
