<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use App\Models\ClassRoom;
use App\Models\Material;
use App\Models\Student;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class DashboardController extends Controller
{

    public function index()
    {

        $current_month_student = Student::query()->whereMonth('created_at', Carbon::now()->month)
        ->whereYear('created_at', Carbon::now()->year)->count();
    $previous_month_student = Student::query()->whereMonth('created_at', Carbon::now()->subMonth())
        ->whereYear('created_at', Carbon::now()->year)->count();

    $data['totalStudents'] = Student::query()->count();
     $data['activeStudents'] = Student::query()->where('is_active', 1)->count();
     $data['inactiveStudents'] = Student::query()->where('is_active', 0)->count();
     $data['storageUsage'] = $this->calculateStorageUsage();

    //$this->studentsWithLessons'] = Student::with('watchLessons')->get();
    $data['averageLessonsWatched'] = Student::averageLessonsWatchedByAllStudents();
    $data['averageLessonsMark'] = Student::averageMarksForAllStudents();
    $data['rateLessonWatchChange'] = Student::averageLessonsWatchedRate();
    $data['classRooms'] = ClassRoom::query()->get();

    $data['students'] = Student::query()->paginate(10);
    $data['materials'] = Material::query()->take(10)->get();


    // Get monthly averages
    $data['urrentMonthAverage'] = Student::averageLessonsWatchedForCurrentMonth();
        return view('dashboard.index', $data);
    }


    public function calculateStorageUsage()
    {
        $totalSize = 0;

        // Get all files in the public storage
        $files = Storage::allFiles('public');

        foreach ($files as $file) {
            $totalSize += Storage::size($file);
        }

        // Convert size to megabytes
        return round($totalSize / 1024 / 1024, 0); // MB
    }


}
