<?php

namespace App\Http\Controllers\Dashboard\EducationAreaes;

use App\Http\Controllers\Controller;
use App\Models\EducationalArea;
use App\Models\Governorate;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class EducationAreaController extends Controller
{
    public function index(Request $request)
    {
        $data['modal'] = $request->modal;
        $data['governorates']=Governorate::query()->get();
        return view('dashboard.educationArea.index', $data); // Load the view for DataTable
    }

    public function getIndex(Request $request)
    {

        $search = $request->search['value']??false;
        $search_governorate_id=$request->search_governorate_id??false;
        // if ($request->ajax()) {
            $query = EducationalArea::query()->with(['governorates'])


            ->when($search_governorate_id, function ($q) use ($search_governorate_id) {
                if($search_governorate_id !=-1){
                $q->where('governorate_id', $search_governorate_id );
                }
            })

                ->when($search, function ($q) use ($search) {
                    $q->where('name', 'like', '%' . $search . '%');
                });

            // Sort based on the column name from DataTables
            if ($request->has('order')) {

                $columnIndex = $request->input('order.0.column'); // Get the index of the column to sort
                $direction = $request->input('order.0.dir'); // Get the sort direction (asc or desc)
                $columns = ['id', 'name']; // List of sortable columns

                // Validate and apply the sort
                if (isset($columns[$columnIndex])) {
                    $query->orderBy($columns[$columnIndex], $direction);
                }
            }


            return DataTables::of($query)
                ->addColumn('name', function ($data) {

                    return $data->name;
                })
                ->addColumn('governorates', function ($data) {


                        return $data->governorates?->name;
                    })




                ->addColumn('actions', function ($data) {

                    return view('dashboard.educationArea.partials.actions',compact('data'));
                })
                ->rawColumns(['actions'])
                ->make(true);
        // }

        return response()->json(['error' => 'Invalid request'], 400);
    }


    public function store(Request $request)
    {
        // Exclude the non-standard name fields from the request data
        $data = $request->except(['education_area_id']);





        EducationalArea::create($data);
        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنحاح',
        ]);
    }

    public  function  update(Request $request)
    {
        $data = $request->except(['education_area_id']);
        EducationalArea::query()->where('id', $request->education_area_id)->update([
            'name' => $request->name,
            'governorate_id'=>$request->governorate_id
        ]);

        // Return a successful response with the created company data
        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنحاح',
        ]);
    }


    public  function  delete(Request $request)
    {

        EducationalArea::query()->where('id', $request->id)->delete();
        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنحاح',
        ]);
    }
}
