<?php

namespace App\Http\Controllers\Dashboard\Exams;

use App\Http\Controllers\Controller;
use App\Models\Chapter;
use App\Models\ClassRoom;
use App\Models\Exam;
use App\Models\Lesson;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class ExamController extends Controller
{
    public function index(Request $request)
    {
        $data['modal'] = $request->modal;
        $data['classRooms'] = ClassRoom::query()->get();
        return view('dashboard.exams.index', $data); // Load the view for DataTable
    }

    public function getIndex(Request $request)
    {

        $search = $request->search['value'] ?? false;
        $search_class_room_id = $request->search_class_room_id ?? false;
        $search_material_id = $request->search_material_id ?? false;
        $search_chapter_id = $request->search_chapter_id ?? false;


        // if ($request->ajax()) {
        $query = Exam::query()


            ->when($search, function ($q) use ($search) {
                $q->where('name', 'like', '%' . $search . '%');
            })
            ->when($search_class_room_id, function ($q) use ($search_class_room_id) {

                    if ($search_class_room_id != -1) {
                        $q->where('class_room_id', $search_class_room_id);
                    }
            })
            ->when($search_material_id, function ($q) use ($search_material_id,$search_class_room_id) {

                if ($search_class_room_id != -1&&($search_material_id != -1 ||$search_material_id!='')) {

                    $q->where('material_id', $search_material_id);
                }

            });


        // Sort based on the column name from DataTables
        if ($request->has('order')) {

            $columnIndex = $request->input('order.0.column'); // Get the index of the column to sort
            $direction = $request->input('order.0.dir'); // Get the sort direction (asc or desc)
            $columns = ['id', 'name']; // List of sortable columns

            // Validate and apply the sort
            if (isset($columns[$columnIndex])) {
                $query->orderBy($columns[$columnIndex], $direction);
            }
        }


        return DataTables::of($query)
            ->addColumn('name', function ($data) {

                return $data->name;
            })
            ->addColumn('classRooms', function ($data) {


                return $data->classRooms->name ?? null;
            })

            ->addColumn('materials', function ($data) {


                return $data->materials?->name;
            })






            ->addColumn('actions', function ($data) {

                return view('dashboard.exams.partials.actions', compact('data'));
            })
            ->rawColumns(['actions'])
            ->make(true);
        // }

        return response()->json(['error' => 'Invalid request'], 400);
    }


    public function store(Request $request)
    {
        // Exclude the non-standard name fields from the request data
        $data = $request->except([  '_token', 'exam_id','chapterIds']);


 $exam=Exam::create($data);

 $exam->chapters()->sync($request->chapterIds);
        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنحاح',
        ]);
    }

    public  function  update(Request $request)
    {
        $data = $request->except([  '_token', 'exam_id','chapterIds']);


$exam=Exam::query()->where('id', $request->exam_id)->first();
        Exam::query()->where('id', $request->exam_id)->update($data);
        $exam->chapters()->attach($request->chapterIds);

        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنحاح',
        ]);
    }







    public function getChapters(Request $request){
        $chapters = Chapter::query()  // This will automatically count related questions
        ->where('material_id', $request->material_id)
        ->get();

        $chapters=$chapters->map(function ($chapter) {
            return [
                'id' => $chapter->id,
                'title' => $chapter->title,
                'questions_count' => $chapter->questions(), // Assuming 'questions' is a relationship on the Chapter model
            ];
        });

        // Return the chapters as a JSON response
        return response()->json([
            'chapters' =>$chapters
        ]);
    }

    public  function  delete(Request $request)
    {

        Exam::query()->where('id', $request->id)->delete();
        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنحاح',
        ]);
    }

}
