<?php

namespace App\Http\Controllers\Dashboard\Governorates;

use App\Http\Controllers\Controller;
use App\Http\Requests\Dashboard\Governorates\GovernoraeRequest;
use App\Http\Resources\GovernorateResource;
use App\Models\Governorate;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class GovernorateController extends Controller
{
    public function index(Request $request)
    {
        $data['modal'] = $request->modal;
        return view('dashboard.governorates.index', $data); // Load the view for DataTable
    }

    public function getIndex(Request $request)
    {

        $search = $request->search['value'];
        if ($request->ajax()) {
            $query = Governorate::query()->orderby('id', 'desc')
                ->when($search, function ($q) use ($search) {
                    $q->where('name', 'like', '%' . $search . '%');
                });

            // Sort based on the column name from DataTables
            if ($request->has('order')) {
                $columnIndex = $request->input('order.0.column'); // Get the index of the column to sort
                $direction = $request->input('order.0.dir'); // Get the sort direction (asc or desc)
                $columns = ['id', 'name']; // List of sortable columns

                // Validate and apply the sort
                if (isset($columns[$columnIndex])) {
                    $query->orderBy($columns[$columnIndex], $direction);
                }
            }


            return DataTables::of($query)
                ->addColumn('name', function ($data) {

                    return $data->name;
                })

                ->addColumn('is_active', function ($data) {
                    return view('dashboard.governorates.partials.active_toggle', compact('data'))->render();

                })

                ->addColumn('actions', function ($data) {

                    return view('dashboard.governorates.partials.actions', compact('data'))->render();
                })
                ->rawColumns(['actions', 'is_active'])
                ->make(true);
        }

        return response()->json(['error' => 'Invalid request'], 400);
    }


    public function store(GovernoraeRequest $request)
    {
        // Exclude the non-standard name fields from the request data
        $data = $request->except(['governorate_id']);





        Governorate::create($data);
        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنحاح',
        ]);
    }

    public  function  update(GovernoraeRequest $request)
    {
        $data = $request->except(['governorate_id']);



        Governorate::query()->where('id', $request->governorate_id)->update([
            'name' => $request->name,
            'status' => $request->is_active ? 1 : 0
        ]);

        // Return a successful response with the created company data
        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنحاح',
        ]);
    }


    public  function  delete(Request $request)
    {

        Governorate::query()->where('id', $request->id)->delete();
        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنحاح',
        ]);
    }
}
