<?php

namespace App\Http\Controllers\Dashboard\Labs;

use App\Http\Controllers\Controller;
use App\Models\ClassRoom;
use App\Models\Lab;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class LabController extends Controller
{
    public function index(Request $request)
    {
        $data['modal'] = $request->modal;
        return view('dashboard.labs.index', $data); // Load the view for DataTable
    }

    public function getIndex(Request $request)
    {

        $search = $request->search['value']??false;
            $query = Lab::query()
                ->when($search, function ($q) use ($search) {
                    $q->where('name', 'like', '%' . $search . '%');
                });

            // Sort based on the column name from DataTables
            if ($request->has('order')) {

                $columnIndex = $request->input('order.0.column'); // Get the index of the column to sort
                $direction = $request->input('order.0.dir'); // Get the sort direction (asc or desc)
                $columns = ['id', 'name']; // List of sortable columns

                // Validate and apply the sort
                if (isset($columns[$columnIndex])) {
                    $query->orderBy($columns[$columnIndex], $direction);
                }
            }


            return DataTables::of($query)
                ->addColumn('name', function ($data) {

                    return $data->name;
                })





                ->addColumn('actions', function ($data) {

                    return view('dashboard.labs.partials.actions',compact('data'));
                })
                ->rawColumns(['actions'])
                ->make(true);
        // }

        return response()->json(['error' => 'Invalid request'], 400);
    }


    public function store(Request $request)
    {
        // Exclude the non-standard name fields from the request data
        $data = $request->except(['lab_id']);





        Lab::create($data);
        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنحاح',
        ]);
    }

    public  function  update(Request $request)
    {
        $data = $request->except(['class_room_id']);
        Lab::query()->where('id', $request->lab_id)->update([
            'name' => $request->name,
        ]);

        // Return a successful response with the created company data
        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنحاح',
        ]);
    }


    public  function  delete(Request $request)
    {

        Lab::query()->where('id', $request->id)->delete();
        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنحاح',
        ]);
    }
}
