<?php

namespace App\Http\Controllers\Dashboard\Matireals;

use App\Http\Controllers\Controller;
use App\Models\Chapter;
use App\Models\ClassRoom;
use App\Models\Exam;
use App\Models\Material;
use App\Models\MaterialAttachment;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class MatirealsController extends Controller
{
    public function index(Request $request)
    {
        $data['modal'] = $request->modal;
        $data['classRooms'] = ClassRoom::query()->get();
        return view('dashboard.matireals.index', $data); // Load the view for DataTable
    }

    public function getIndex(Request $request)
    {

        $search = $request->search['value'] ?? false;
        $search_class_room_id = $request->search_class_room_id ?? false;
        // if ($request->ajax()) {
        $query = Material::query()->with(['classRooms'])


            ->when($search_class_room_id, function ($q) use ($search_class_room_id) {
                if ($search_class_room_id != -1) {
                    $q->where('class_room_id', $search_class_room_id);
                }
            })

            ->when($search, function ($q) use ($search) {
                $q->where('name', 'like', '%' . $search . '%');
            });

        // Sort based on the column name from DataTables
        if ($request->has('order')) {

            $columnIndex = $request->input('order.0.column'); // Get the index of the column to sort
            $direction = $request->input('order.0.dir'); // Get the sort direction (asc or desc)
            $columns = ['id', 'name']; // List of sortable columns

            // Validate and apply the sort
            if (isset($columns[$columnIndex])) {
                $query->orderBy($columns[$columnIndex], $direction);
            }
        }


        return DataTables::of($query)
            ->addColumn('name', function ($data) {

                return $data->name;
            })
            ->addColumn('classRooms', function ($data) {


                return $data->classRooms?->name;
            })




            ->addColumn('actions', function ($data) {

                return view('dashboard.matireals.partials.actions', compact('data'));
            })
            ->rawColumns(['actions'])
            ->make(true);
        // }

        return response()->json(['error' => 'Invalid request'], 400);
    }


    public function store(Request $request)
    {
        // Exclude the non-standard name fields from the request data
        $data = $request->except(['material_id', 'photo']);

        if ($request->photo) {
            $classRoom = ClassRoom::query()->find($request->class_room_id);
            $destinationPath = $classRoom->code . '/' . $request->code . '/materials/'; // Append the file name only
            $data['attachment'] = $request->photo->store($destinationPath, 'public');
        }
        Material::create($data);
        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنحاح',
        ]);
    }

    public  function  update(Request $request)
    {
        $data = $request->except(['material_id', 'photo', '_token']);

        if ($request->photo) {
            $classRoom = ClassRoom::query()->find($request->class_room_id);
            $destinationPath = $classRoom->code . '/' . $request->code . '/materials/'; // Append the file name only
            $data['attachment'] = $request->photo->store($destinationPath, 'public');
        }

        Material::query()->where('id', $request->material_id)->update($data);

        // Return a successful response with the created company data
        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنحاح',
        ]);
    }


    public function getAttachments(Request $request)
    {
        $material_id = $request->input('material_id');

        // Fetch attachments for the given material_id
        $attachments = MaterialAttachment::where('material_id', $material_id)->get();

        return response()->json(['attachments' => $attachments]);
    }
    public function saveAttachment(Request $request)
    {


        $data = $request->except(['attachment_book', '_token']);

        $attachment = '';
        if ($request->attachment_book) {
            $material =    Material::query()->where('id', $request->attachment_matireal_id)->first();

            $classRoom = ClassRoom::query()->find($material->class_room_id);
            $destinationPath = $classRoom->code . '/' . $material->code . '/materials/'; // Append the file name only
            $attachment = $request->attachment_book->store($destinationPath, 'public');
        }

        MaterialAttachment::query()->create([
            'material_id' => $material->id,
            'attachment' => $attachment,
            'title' => $request->attachment_title
        ]);


        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنحاح',
        ]);
    }


    public function getChapters(Request $request)
    {
        $material_id = $request->input('material_id');

        // Fetch attachments for the given material_id
        $chapters = Chapter::query()->with(['classRooms', 'materials'])->where('material_id', $material_id)->get();

        $chapters = $chapters->map(function ($chapter) {
            // Provide default values if the relationships are null
            $chapter->material_name = $chapter->materials ? $chapter->materials->name : 'غير متوفر';
            $chapter->class_room_name = $chapter->classRooms ? $chapter->classRooms->name : 'غير متوفر';

            return $chapter;
        });
        return response()->json(['chapters' => $chapters]);
    }


    public function addchapter(Request $request)
    {


        $material = Material::findorfail($request->add_chapter_matireal_id);

        foreach ($request->chapter_title as $key => $value) {
            Chapter::query()->create([
                'material_id' => $request->add_chapter_matireal_id,
                'class_room_id' => $material->class_room_id,
                'title' => $value,
                'description' => $request->chapter_description[$key],
                'name' => $request->chapter_code[$key],
            ]);
        }

        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنحاح',
        ]);
    }


    public function getChaptersByMaterialId(Request $request)
    {
        $materialId = $request->input('material_id');

        // Fetch chapters related to the material_id
        $chapters = Chapter::where('material_id', $materialId)->get();

        // Return chapters as a JSON response
        return response()->json([
            'chapters' => $chapters,
        ]);
    }
    public  function  delete(Request $request)
    {

        Material::query()->where('id', $request->id)->delete();
        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنحاح',
        ]);
    }
    public function getExams(Request $request)
    {
        $materialId = $request->input('material_id');

        // Fetch exams related to the material (assuming a relationship is set up)
        $exams = Exam::where('material_id', $materialId)->get();

        // Return the exams as a JSON response
        return response()->json([
            'success' => true,
            'exams' => $exams
        ]);
    }


    public function addExam(Request $request)
    {
        $material = Material::findorfail($request->add_exam_material_id);

        $exam = Exam::query()->create([
            'name' => $request->exam_name,
            'class_room_id' => $material->class_room_id,
            'material_id' => $request->add_exam_material_id,
            'question_count' => $request->question_count,
        ]);
        $exam->chapters()->sync($request->chapter_ids);

        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنحاح',
        ]);
    }
}
