<?php

namespace App\Http\Controllers\Dashboard\Notifications;

use App\Http\Controllers\Controller;
use App\Http\Requests\SendAdminNotificationRequest;
use App\Models\Driver;
use App\Models\Notification as ModelsNotification;
use App\Models\Student;
use App\Models\User;
use App\Notifications\SendAdminNotification;
use App\Services\Firebase\FirebaseNotification;
// use App\Notifications\SendAdminNotification;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Notification;

class NotificationController extends Controller
{
    //

    public $notifications;
    public function __construct(FirebaseNotification $notifications)
    {
        $this->notifications = $notifications;
    }

    public function create()
    {

        $data['students'] = Student::query()->whereNotNull('fcm_token')
        ->get();
        return view('dashboard.notifications.create', $data);
    }
    public function store(Request $request)
    {

        $student_id=$request->student_id??false;
        $users = Student::query()->whereNotNull('fcm_token')
        ->when($student_id,function($q) use($student_id){
            $q->whereIn('id',$student_id);
        })
        ->get();

        $data = [
            'title' => $request->title,
            'body' => $request->body,
        ];
                foreach ($users as $value) {

            $data = [];


            ModelsNotification::query()->create([
                'user_id'=>$value->id,
                'notifiable_id'=>$value->id,
                'title' => $request->title ?? null, // Safely retrieve the 'title' key
                'body' => $request->body?? null,   // Safely retrieve the 'body' key
                'order_id' => null, // Default to null if key doesn't exist
                'read_at' => null,
                'notification_type' => $data['notification_type'] ?? 'general', // Default to 'general'
            ]);
            $this->notifications->send($request->title, $request->body, $data, $value->fcm_token);

        }

        return response()->json([
            'success' => true,
            'message' => __('messages.success_full_process'),
        ]);
    }
}
