<?php

namespace App\Http\Controllers\Dashboard\Roles;

use App\Http\Controllers\Controller;
use App\Models\Permission;
use App\Models\Role;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class RoleController extends Controller
{
    public function index(Request $request)
    {
        return view('dashboard.roles.index', [
            'modal' => $request->modal,
            'permissions' => Permission::all(),
        ]);
    }

    public function getIndex(Request $request)
    {
        $search = $request->search['value'] ?? null;

        $query = Role::when($search, fn($q) => $q->where('name', 'like', "%$search%"));

        if ($request->has('order')) {
            $columns = ['id', 'name'];
            $columnIndex = $request->input('order.0.column');
            $direction = $request->input('order.0.dir');

            if (isset($columns[$columnIndex])) {
                $query->orderBy($columns[$columnIndex], $direction);
            }
        }

        return DataTables::of($query)
            ->addColumn('actions', fn($data) => view('dashboard.roles.partials.actions', compact('data')))
            ->rawColumns(['actions'])
            ->make(true);
    }

    public function store(Request $request)
    {
        $data = $request->except(['role_id', '_token', 'permission_elements']);
        $data['guard_name'] = $request->name;

        $role = Role::create($data);
        $role->permissions()->attach($request->permission_elements);

        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنجاح',
        ]);
    }

    public function update(Request $request)
    {
        $data = $request->except(['role_id', '_token','permission_elements']);
      $role = Role::where('id', $request->role_id)->first();

      $role->update([
        'name'=>$request->name,
      ]);
        $role->permissions()->attach($request->permission_elements);

        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنجاح',
        ]);
    }

    public function delete(Request $request)
    {
        Role::where('id', $request->id)->delete();

        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنجاح',
        ]);
    }

}
