<?php

namespace App\Http\Controllers\Dashboard\Settings;

use App\Http\Controllers\Controller;
use App\Http\Requests\Dashboard\Settings\SettingsRequest;
use App\Models\Setting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class SettingController extends Controller
{
    //

    public  function  index(){


        return view('dashboard.settings.index');
    }

    public function page(){
        $data['policy']= settings('privacy_policy','privacyPolicy');

        return view('pages.settings.index',$data);
    }

    public function  deleteAccountPolicy(){
        return view('pages.settings.delete_acount');
    }

    public  function  update(SettingsRequest $request){

        $setting_general=  settings('general','name');

        $setting_general->update([
            'value'=>$request->name
        ]);
        $setting_description=  settings('general','description');
        $setting_description->update([
            'value'=>$request->description
        ]);


        $privacyPolicy=  settings('privacy_policy','privacyPolicy');
        $privacyPolicy->update([
            'value'=>$request->privacy_policy
        ]);

        $privacyPolicy=  settings('terms_and_conditions','termsConditions');
        $privacyPolicy->update([
            'value'=>$request->term_condition
        ]);











        if($request->logo){
            $setting_logo=  settings('general','logo');
            if ($setting_logo->value && Storage::disk('public')->exists($setting_logo->value)) {
                Storage::disk('public')->delete($setting_logo->value);
            }
            $path = $request->file('logo')->store('settings','public');
            $setting_logo->update([
                'value'=>$path
            ]);
        }

//
        if($request->cover_logo){
            $cover_logo=  settings('general','coverLogo');
            if ($cover_logo->value && Storage::disk('public')->exists($cover_logo->value)) {
                Storage::disk('public')->delete($cover_logo->value);
            }
            $path = $request->file('cover_logo')->store('settings','public');
            $cover_logo->update([
                'value'=>$path
            ]);
        }

        if($request->icon_logo){
            $icon_logo=  settings('general','iconLogo');
            if ($icon_logo->value && Storage::disk('public')->exists($icon_logo->value)) {
                Storage::disk('public')->delete($icon_logo->value);
            }
            $path = $request->file('icon_logo')->store('settings','public');
            $icon_logo->update([
                'value'=>$path
            ]);
        }

        return response()->json([
            'success' => true,
            'message' => 'تم تنفيد العملية بنجاح',
        ]);

    }







}
