<?php

namespace App\Http\Controllers\Dashboard\Shcools;

use App\Exports\ErrorSchoolExportExeclSheet;
use App\Http\Controllers\Controller;
use App\Imports\SchoolsImport;
use App\Models\EducationalArea;
use App\Models\School;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;
use Yajra\DataTables\Facades\DataTables;

class ShcoolController extends Controller
{
    public function index(Request $request)
    {
        $data['modal'] = $request->modal;
        $data['educationalAreas'] = EducationalArea::all();
        return view('dashboard.schools.index', $data);
    }

    public function getIndex(Request $request)
    {
        $search = $request->search['value'] ?? false;
        $search_education_area_id = $request->search_education_area_id ?? false;

        $query = School::with(['educationalAreas'])
            ->when($search_education_area_id, function ($q) use ($search_education_area_id) {
                if ($search_education_area_id != -1) {
                    $q->where('educational_area_id', $search_education_area_id);
                }
            })
            ->when($search, function ($q) use ($search) {
                $q->where('name', 'like', '%' . $search . '%');
            });

        if ($request->has('order')) {
            $columnIndex = $request->input('order.0.column');
            $direction = $request->input('order.0.dir');
            $columns = ['id', 'name'];

            if (isset($columns[$columnIndex])) {
                $query->orderBy($columns[$columnIndex], $direction);
            }
        }

        return DataTables::of($query)
            ->addColumn('name', fn($data) => $data->name)
            ->addColumn('educationalAreas', fn($data) => $data->educationalAreas?->name)
            ->addColumn('actions', fn($data) => view('dashboard.schools.partials.actions', compact('data')))
            ->rawColumns(['actions'])
            ->make(true);
    }

    public function store(Request $request)
    {
        School::create($request->except(['school_id']));
        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنجاح',
        ]);
    }

    public function update(Request $request)
    {
        School::where('id', $request->school_id)
            ->update([
                'name' => $request->name,
                'educational_area_id' => $request->educational_area_id
            ]);

        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنجاح',
        ]);
    }

    public function delete(Request $request)
    {
        School::where('id', $request->id)->delete();
        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنجاح',
        ]);
    }

    public function uploadExcel(Request $request)
    {
        try {
            $import = new SchoolsImport();
            Excel::import($import, $request->file('excel_file'));

            if ($import->getErrors()) {
                $fileName = 'upload_errors_' . now()->timestamp . '.xlsx';
                $filePath = storage_path('app/public/' . $fileName);

                Excel::store(new ErrorSchoolExportExeclSheet($import->getErrors()), 'public/' . $fileName);

                return response()->json([
                    'success' => false,
                    'message' => 'File download available.',
                    'download_url' => asset('storage/' . $fileName),
                ]);
            }

            return response()->json([
                'success' => true,
                'message' => 'File uploaded successfully',
            ]);
        } catch (\Maatwebsite\Excel\Validators\ValidationException $e) {
            return response()->json([
                'success' => false,
                'message' => 'Validation errors occurred during import.',
                'errors' => $e->failures(),
            ]);
        } catch (\Exception $e) {
            return $e;
            return response()->json([
                'success' => false,
                'message' => 'An error occurred while processing the file.',
            ]);
        }
    }
}
