<?php

namespace App\Http\Controllers\Dashboard\Students;

use App\Exports\ErrorStudenntExportExeclSheet;
use App\Http\Controllers\Controller;
use App\Imports\NewStudentImoortExeclSheet;
use App\Models\ClassRoom;
use App\Models\EducationalArea;
use App\Models\Governorate;
use App\Models\Level;
use App\Models\School;
use App\Models\Student;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Maatwebsite\Excel\Facades\Excel;
use Yajra\DataTables\Facades\DataTables;

class StudentController extends Controller
{
    public function index(Request $request)
    {
        $data['modal'] = $request->modal;
        $data['educationalAreas'] = EducationalArea::query()->get();
        $data['classRooms'] = ClassRoom::query()->get();
        $data['schools'] = School::query()->get();
        $data['governorates'] = Governorate::query()->get();
        $data['levels'] = Level::query()->get();


        return view('dashboard.students.index', $data); // Load the view for DataTable
    }

    public function getIndex(Request $request)
    {
        $search = $request->search['value'] ?? false;
        $search_education_area_id = $request->search_education_area_id ?? false;
        $search_class_room_id = $request->search_class_room_id ?? false;

        $query = Student::query()->with(['educationalArea', 'school', 'classRooms'])
            ->when($search_class_room_id, function ($q) use ($search_class_room_id) {
                if ($search_class_room_id != -1) {
                    $q->where('class_room_id', $search_class_room_id);
                }
            })
            ->when($search_education_area_id, function ($q) use ($search_education_area_id) {
                if ($search_education_area_id != -1) {
                    $q->where('educational_area_id', $search_education_area_id);
                }
            });

        if ($search) {
            $query->where(function ($q) use ($search) {
                $q->where('students.name', 'like', '%' . $search . '%')
                    ->orWhere('students.id_number', 'like', '%' . $search . '%');
            });
        }


        if ($request->has('order')) {
            $columnIndex = $request->input('order.0.column');
            $direction = $request->input('order.0.dir');
            $columns = ['id', 'name'];

            if (isset($columns[$columnIndex])) {
                $query->orderBy($columns[$columnIndex], $direction);
            }
        }

        return DataTables::of($query->get())
            ->addColumn('name', function ($data) {
                return $data->name;
            })
            ->addColumn('classRooms', function ($data) {
                return $data->classRooms?->name;
            })
            ->addColumn('schools', function ($data) {
                return $data->school ? $data->school->name : null;
            })
            ->addColumn('educationArea', function ($data) {
                return $data->school?->educationalAreas?->name;
            })
            ->addColumn('actions', function ($data) {
                return view('dashboard.students.partials.actions', compact('data'));
            })
            ->rawColumns(['actions'])
            ->make(true);
    }



    public function store(Request $request)
    {
        // Exclude the non-standard name fields from the request data
        $data = $request->except(['student_id', 'password']);
        $data['password'] = Hash::make('password');


        $data['code'] = rand(1000, 9999);
        Student::create($data);
        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنحاح',
        ]);
    }

    public  function  update(Request $request)
    {
        $data = $request->except(['student_id', 'password', '_token']);
        $student =  Student::query()->where('id', $request->student_id)->first();

        $student->update($data);

        if ($request->password) {
            $student->update([
                'password' => Hash::make($request->password),
            ]);
        }
        // Return a successful response with the created company data
        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنحاح',
        ]);
    }


    public  function  delete(Request $request)
    {

        Student::query()->where('id', $request->id)->delete();
        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنحاح',
        ]);
    }

    public function uploadExcel(Request $request)
    {
        // dd($request);
        // Validate the uploaded file
        $request->validate([
            'excel_file' => 'required|mimes:xlsx,xls,csv',
        ]);

        try {
            $import = new NewStudentImoortExeclSheet();
            Excel::import($import, $request->file('excel_file'));

            // Check if there are row-specific errors
            if ($import->getErrors()) {
                // Export the errors
                $fileName = 'upload_errors_' . now()->timestamp . '.xlsx';
                $filePath = storage_path('app/public/' . $fileName);

                Excel::store(new ErrorStudenntExportExeclSheet($import->getErrors()), 'public/' . $fileName);

                // Generate a download URL
                $downloadUrl = asset('storage/' . $fileName);

                return response()->json([
                    'success' => false,
                    'message' => 'File download available.',
                    'download_url' => $downloadUrl,
                ]);
            }

            return response()->json([
                'success' => true,
                'message' => 'File uploaded successfully',
            ]);
        } catch (\Maatwebsite\Excel\Validators\ValidationException $e) {
            // Catch validation errors from Excel rows
            return response()->json([
                'success' => false,
                'message' => 'Validation errors occurred during import.',
                'errors' => $e->failures(), // Return validation errors
            ]);
        } catch (\Exception $e) {
            return $e;
            return response()->json([
                'success' => false,
                'message' => 'An error occurred while processing the file.',
            ]);
        }
    }
}
