<?php

namespace App\Http\Controllers\Dashboard\classSections;

use App\Http\Controllers\Controller;
use App\Models\ClassRoom;
use App\Models\ClassSection;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class classSectionController extends Controller
{
    public function index(Request $request)
    {
        $data['modal'] = $request->modal;
        $data['classRooms'] = ClassRoom::query()->get();
        return view('dashboard.classSections.index', $data); // Load the view for DataTable
    }

    public function getIndex(Request $request)
    {

        $search = $request->search['value'] ?? false;
        $search_class_room_id = $request->search_class_room_id ?? false;
        // if ($request->ajax()) {
        $query = ClassSection::query()->with(['classRooms'])


            ->when($search_class_room_id, function ($q) use ($search_class_room_id) {
                if ($search_class_room_id != -1) {
                    $q->where('class_room_id', $search_class_room_id);
                }
            })

            ->when($search, function ($q) use ($search) {
                $q->where('name', 'like', '%' . $search . '%');
            });

        // Sort based on the column name from DataTables
        if ($request->has('order')) {

            $columnIndex = $request->input('order.0.column'); // Get the index of the column to sort
            $direction = $request->input('order.0.dir'); // Get the sort direction (asc or desc)
            $columns = ['id', 'name']; // List of sortable columns

            // Validate and apply the sort
            if (isset($columns[$columnIndex])) {
                $query->orderBy($columns[$columnIndex], $direction);
            }
        }


        return DataTables::of($query)
            ->addColumn('name', function ($data) {

                return $data->name;
            })
            ->addColumn('classRooms', function ($data) {


                return $data->classRooms?->name;
            })




            ->addColumn('actions', function ($data) {

                return view('dashboard.classSections.partials.actions', compact('data'));
            })
            ->rawColumns(['actions'])
            ->make(true);
        // }

        return response()->json(['error' => 'Invalid request'], 400);
    }


    public function store(Request $request)
    {
        // Exclude the non-standard name fields from the request data
        $data = $request->except(['class_section_id']);


        ClassSection::create($data);
        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنحاح',
        ]);
    }

    public  function  update(Request $request)
    {
        $data = $request->except(['class_section_id',  '_token']);



        ClassSection::query()->where('id', $request->class_section_id)->update($data);

        // Return a successful response with the created company data
        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنحاح',
        ]);
    }







    public  function  delete(Request $request)
    {

        ClassSection::query()->where('id', $request->id)->delete();
        return response()->json([
            'success' => true,
            'message' => 'تمت العملية بنحاح',
        ]);
    }




}
