<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class RemoveLanguagePrefix
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {

        $path = $request->path();
        $locale = ['ar', 'en'];

        foreach ($locale as $lang) {
            if (str_starts_with($path, $lang . '/')) {
                return redirect()->to(substr($path, strlen($lang) + 1));
            }
        }

        return $next($request);
    }

}
