<?php

namespace App\Http\Requests\Admin\Chapters;

use Illuminate\Foundation\Http\FormRequest;

class ChapterMaterailRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'chapters.*.name' => 'required|string|max:255',
            'chapters.*.title' => 'required|string|max:255',
            'chapters.*.description' => 'required|string|max:255',

//            'attachment' => 'required|image|max:1024', // Validation rules

//            'chapters.*.class_room_id' => 'required|exists:class_rooms',
//            'chapters.*.materail' => 'required|exists:class_rooms',


        ];
    }

    public function messages()
    {
        return [
            'chapters.*.name.required' => 'الاسم مطلوب',
            'chapters.*.name.string' => 'يجب ان يكون نصا.',
            'chapters.*.name.max' => 'الحجم النص يجب ان يكون اقل من 255 حرفا.',
        ];
    }
}
