<?php

namespace App\Http\Requests\Admin\Materials;

use Illuminate\Foundation\Http\FormRequest;

class MaterialRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize()
    {
        return true; // Set to true if authorization is not needed
    }

    public function rules()
    {
        
        return [
            'name' => ['required', 'string', 'max:255'],
            'classRoomId' => ['required', 'exists:class_rooms,id'],
            'status' => ['required'],
            'attachment' => ['nullable', 'file', 'mimes:jpg,jpeg,png,pdf', 'max:2048'], // Accepts images and PDFs with a size limit of 2MB
        ];
    }

    public function messages()
    {
        return [
            'name.required' => 'الاسم مطلوب.',
            'name.string' => 'الاسم يجب ان يكون نصا.',
            'name.max' => 'يجب ان يكون حجم النص اقل من 255 حرف.',
            'classRoomId.required' => 'الصف الدراسي مطلوبة.',
            'classRoomId.exists' => 'الصف الدراسي غير موجودة.',
        ];
    }

}
