<?php

namespace App\Http\Requests\Auth;

use Illuminate\Foundation\Http\FormRequest;

class LoginRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'email' => [
                'required',
                'exists:admins,email',
                function ($attribute, $value, $fail) {
                    $admin = \App\Models\Admin::where('email', $value)->first();
                    if (!$admin || !\Illuminate\Support\Facades\Hash::check(request()->password, $admin->password)) {
                        $fail('The provided credentials do not match our records.');
                    }
                },
            ],
            'password' => 'required',
        ];
    }
}
