<?php

namespace App\Http\Requests\Dashboard\Admins;

use Illuminate\Foundation\Http\FormRequest;

class AdminRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'email'=>'required|unique:admins,email,except,'.$this->admin_id,
            'phone'=>'required|unique:admins,phone,except,'.$this->admin_id,
            'name'=>'required|string',
            'password'=>'required|min:6',
            'role_id'=>'required|exists:roles,id',
        ];
    }
}
