<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ChapterResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id'=>$this->id,
            'chapterName'=>$this->name,
            'chapterTitle'=>$this->title,
            'chapterDescription'=>$this->description,
            'numberOfLessons'=> (string)$this->numberOfLessons(),
            'videos'=>LessonResource::collection($this->lessons),
        ];
    }
}
