<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ContestQuestionResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id'=>$this->id,
            'attachment'=>$this->attachment?$this->getAttachments():null,
            'question_type'=>$this->question_type,
            'options'=>ContestAnswersource::collection($this->answers),
            'correctOptionId'=>$this->is_correct,
        ];
    }
}
