<?php

namespace App\Http\Resources;

use App\Models\ContestQuestion;
use App\Models\illustrationContest;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ContestResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        // Retrieve illustration contests linked to this contest

        // Build the base data array
        $data = [
            'id' => $this->id,
            'name' => $this->name,
            'date' => $this->date,
            'photo' => $this->getAttachment(),
            'start_time' => Carbon::parse($this->start_time)->format('h:i A'),
            'end_time' => Carbon::parse($this->end_time)->format('h:i A'),
            'duration' => $this->duration,
            'question_count' => $this->question_count,
            'is_available' => $this->isAvailable(),
            'correct_code'=>$this->correct_code,
            'mark' => $this->getMark(),
            'models' => ModelResource::collection($this->models),
            'questions' => $this->merge(
                [
                    ...$this->whenLoaded('illustrations', fn () => (IllutrationContestResource::collection($this->illustrations)->toArray($request))),
                    [
                        'photo' => null,
                        'question' => $this->whenLoaded('questionsWithoutIllustrations', fn () => ContestQuestionResource::collection($this->questionsWithoutIllustrations()->get())),

                        ]

                ]
            )->data,



            // $this->mergeWhen($questions->isNotEmpty(),[
            //     'photo' => null, // Assuming no photo available
            //     'questions' => AllContestQuestionResource::collection($questions),
            // ])
        ];

        // // Initialize the questions key as an empty array
        // $data['questions'] = [];


        // // Add `illustrationContests` data if available
        // if ($illustrationContests->isNotEmpty()) {
        //     $data['questions'][] = IllutrationContestResource::collection($illustrationContests);
        // }

        // // Add standalone `questions` data if available
        // if ($questions->isNotEmpty()) {
        //     $data['questions'][] = [
        //         'photo' => null,
        //         'question'=>ContestQuestionResource::collection($this->questions)
        //         // Assuming no photo available
        //     ];
        // }

        return $data;
    }
}
