<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ExamResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id'=>$this->id,
            'name'=>$this->name,
            'exam_time'=>$this->exam_time,
            'question_count'=>$this->question_count,
            'chapters'=>ChapterExamResource::collection($this->chapters),
        ];
    }
}
