<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class LessonResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id'=>$this->id,
            "title"=> $this->name,
            "description"=> $this->description,
            "videoUrl"=>$this->getVedioUrl(),
//            "thumbnailUrl"=>$this->getPhotoUrl(),
            'questions'=>QuestionsResource::collection($this->questions),
            "videoPath"=> null,
         //   "thumbnailPath"=>null,
//            "is_watch_lesson"=>$this->isWatchLesson(),
//            "is_mark_lesson"=>$this->isMarkLesson(),

        ];
    }
}
