<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class QuestionsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id'=>$this->id,
             'questionText'=>$this->questions,
            'options'=>AnswerResource::collection($this->answers),
              'attachment'=>$this->attachment?$this->getAttachments():null,

            'correctOptionId'=>$this->is_correct,
        ];
    }
}
