<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class StudentProfileResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id'=>$this->id,
            'token'=>$this->plainTextToken??$request->bearerToken(),
            'name'=>$this->name,
            'code'=>$this->code,
            'id_number'=>$this->id_number,
            'governorate'=>$this->governorate?new GovernorateResource($this->governorate):[
                'id'=>0,
                'name'=>"",
            ],
            'educational_area'=>$this->educationalArea?new EducationalAreaResource($this->educationalArea):[
                'id'=>0,
                'name'=>"",
            ],
            'school'=>$this->school?new SchoollResource($this->school):[
                'id'=>0,
                'name'=>"",
            ],
            'class_room'=>new ShortClassRoomResource($this->classRooms),

            'level'=>new ShortClassRoomResource($this->levels),
            'is_active'=>$this->is_active?true:false,

        ];
    }
}
