<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class StudentResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id'=>$this->id,
            'name'=>$this->name,
            'id_number'=>$this->id_number,
            'governorate'=>new GovernorateResource($this->governorate),
            'educational_area'=>new EducationalAreaResource($this->educationalArea),
            'school'=>new SchoollResource($this->school),
            'class_room'=>new ShortClassRoomResource($this->classRooms),
            'is_active'=>$this->is_active?true:false,

        ];
    }
}
