<?php

namespace App\Http\Resources;

use App\Models\Chapter;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class SubjectsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {

        return [
            'id'=>$this->id,
            'subjectName'=>$this->name,
            'exam'=>ExamResource::collection($this->exams),
            'subjectImage'=> $this->getAttachment(),
            'attachment'=>AttachmentResource::collection($this->attachments),
//            'subjectPdf'=>$this->subjectPdf,
            'numberOfChapters'=>(string)$this->numberOfChapters(),
            'chapters'=>ChapterResource::collection($this->chapters),

        ];
    }
}
