<?php

namespace App\Imports;

use App\Models\Governorate;
use App\Models\School;
use App\Models\ClassRoom;
use App\Models\Level;
use App\Models\Student;
use Illuminate\Support\Facades\Hash;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithValidation;
use Maatwebsite\Excel\Concerns\SkipsOnError;
use Maatwebsite\Excel\Concerns\SkipsErrors;
use Maatwebsite\Excel\Concerns\SkipsFailures;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\SkipsOnFailure;

class NewStudentImoortExeclSheet implements ToModel, WithValidation, WithHeadingRow, SkipsOnError, SkipsOnFailure
{
    use SkipsErrors, SkipsFailures;

    public $failedRows = []; // Array to store failed rows

    protected $errors = []; // Store row-level errors


    protected $attributeToColumnMap = [
        'name' => 'Name',
        'id_number' => 'Id Number',
        'governorate_name' => 'Governorate Name',
        'school_name' => 'School Name',
        'classroom_name' => 'Classroom Name',
        'level_code' => 'Level Code',
        'mobile' => 'Mobile',
        'password' => 'password',

    ];
    public function model(array $row)
    {
        $governorate = Governorate::query()->where('name', $row['governorate_name'])->first();

        if (!$governorate) {

            $this->errors[] = [
                'row' => $row,
                'values' => $row,
                'errors' => ["Governorate not found: " . $row['governorate_name']]
            ];
            return null; // Skip processing this row

    }



        $classRoom = ClassRoom::query()->where('code', $row['classroom_name'])->first();
        if (!$classRoom) {

            $this->errors[] = [
                'row' => $row,
                'values' => $row,
                'errors' => ["Class Room not found: " . $row['classroom_name']]
            ];
            return null; // Skip processing this row

    }
        $level = Level::query()->where('code', $row['level_code'])->first();
        if (!$level) {

                $this->errors[] = [
                    'row' => $row,
                    'values' => $row,
                    'errors' => ["Level not found: " . $row['level_code']]
                ];
                return null; // Skip processing this row

        }

        $school = School::query()->where('name', $row['school_name'])->first();
        if (!$school) {
            $this->errors[] = [
                'row' => $row,
                'values' => $row,
                'errors' => ["School not found: " . $row['level_code']]
            ];
            return null;
        }


        return new Student([
            'name' => $row['name'],
            'code'=>round(1,9999),
            'id_number' => $row['id_number'],
            'governorate_id' => $governorate?->id,
            'school_id' => $school?->id,
            'class_room_id' => $classRoom?->id,
            'level_id'=>$level?->id,
            'mobile' => $row['mobile'],
            'password'=>Hash::make($row['password']),
        ]);
    }

    public function rules(): array
    {
        return [
            'name' => 'required|string|max:255',
            'id_number' => 'required|numeric|unique:students,id_number',

            'governorate_name' => ['required', function ($attribute, $value, $fail) {
                // if (!Governorate::query()->where('name', $value)->exists()) {
                //     $fail("The governorate '{$value}' does not exist.");
                // }
            }],

            'classroom_name' => ['required', function ($attribute, $value, $fail) {
                // if (!ClassRoom::query()->where('code', $value)->exists()) {
                //     $fail("The classroom '{$value}' does not exist.");
                // }
            }],
            'level_code' => ['required', function ($attribute, $value, $fail) {
                // if (!Level::query()->where('code', $value)->exists()) {
                //     $fail("The level '{$value}' does not exist.");
                // }
            }],
            'password' => 'required|min:6',
        ];
    }

    public function onFailure(\Maatwebsite\Excel\Validators\Failure ...$failures)
    {
        foreach ($failures as $failure) {
            $rowIndex = $failure->row();

            if (!isset($this->errors[$rowIndex])) {
                $this->errors[$rowIndex] = [
                    'row' => $rowIndex,
                    'values' => $failure->values(),
                    'errors' => []
                ];
            }

            foreach ($failure->errors() as $field => $error) {
                if (!in_array($error, $this->errors[$rowIndex]['errors'])) {
                    $this->errors[$rowIndex]['errors'][] = $error;
                }
            }
        }
    }

    public function getErrors()
    {
        return $this->errors;
    }
}
