<?php

namespace App\Imports;

use App\Models\Brand;
use App\Models\Category;
use App\Models\Color;
use App\Models\ImageProduct;
use App\Models\Product;
use App\Models\Size;
use Illuminate\Validation\Rule;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Concerns\OnEachRow;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithBatchInserts;
use Maatwebsite\Excel\Concerns\WithChunkReading;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;
use Maatwebsite\Excel\Row;
use App\Models\ColorSizeProduct;
class ProductImport implements ToModel, OnEachRow, WithValidation, WithHeadingRow, WithChunkReading, WithBatchInserts

{
    use Importable;

    public function model(array $row)
    {





        }




    public function onRow(Row $row)
    {



        $parent_category = Category::query()->where('name', 'like', '%' . $row['parent_category_name'] . '%')->first();
        $sub_category = Category::query()->where('name', 'like', '%' . $row['sub_category_name'] . '%')->first();
        $brand = Brand::query()->where('name', 'like', '%' . $row['brand_name'] . '%')->first();
        $slug = $this->slug($row['item_name']);

        $quantity = 0;
        $array_colors = array();
        $array_sizes = array();
        $url = explode(',', $row['images']);
        $colors[] = $row['colors'];
        $qty_color_size[] = $row['quantity_size_color'];
        $buy_mobile=0;

        if($row['buy_mobile']=='FALSE'){
$buy_mobile=0;
        }else{
            $buy_mobile=1;
        }

        if ($row['item_name']) {

                    $product = Product::query()->where('name',   $row['item_name'] )->first();


            if (!$product) {

                $product = Product::query()->create([
                    'name' => $row['item_name'],
                    'slug' => $slug,
                    'seo_name' => $row['item_name'],
                    'short_description' => $row['short_description'],
                    'seo_description' => $row['short_description'],
                    'description' => $row['description'],
                    'regular_price' => $row['regular_price'],
                    'sale_price' => $row['sale_price'] ?? null,
                    'quantity' => $row['quantity'],
                    'available_quantity' => $row['quantity'],
                    'is_shared_mobile' =>$buy_mobile,
                    'SKU' => $row['item_code'],
                    'parent_category_id' => $parent_category ? $parent_category->id : null,
                    'sub_category_id' => $sub_category ? $sub_category->id : null,
                    'brand_id' => $brand ? $brand->id : null,
                    'delivery_time' => $row['delivery_time'] ?? null,
                    'discount_percentage' => $row['discount_percentage'] ?? null,
                    'discount_minimum_number' => $row['discount_minimum_number'] ?? null,


                ]);

            }else{
                $product->update([
                    'name' => $row['item_name'],
                    'slug' => $slug,
                    'seo_name' => $row['item_name'],
                    'short_description' => $row['short_description'],
                    'seo_description' => $row['short_description'],
                    'description' => $row['description'],
                    'regular_price' => $row['regular_price'],
                    'sale_price' => $row['sale_price'] ?? null,
                    'quantity' => $row['quantity'],
                    'available_quantity' => $row['quantity'],
                    'is_shared_mobile' => $buy_mobile,
                    'SKU' => $row['item_code'],
                    'parent_category_id' => $parent_category ? $parent_category->id : null,
                    'sub_category_id' => $sub_category ? $sub_category->id : null,
                    'brand_id' => $brand ? $brand->id : null,
                    'delivery_time' => $row['delivery_time'] ?? null,
                    'discount_percentage' => $row['discount_percentage'] ?? null,
                    'discount_minimum_number' => $row['discount_minimum_number'] ?? null,
                ]);
            }



            $sizes = explode(',', $row['sizes']);

            ImageProduct::query()->where('product_id',$product->id)->delete();
                foreach ($url as $value) {
                    ImageProduct::create([
                        'product_id' => $product->id,
                        'url' => $value,

                    ]);
                }

                foreach ($sizes as $value) {

                    $size = Size::query()->where('name', 'like', '%' . $value . '%')->first();
                    if (isset($size)) {
                        $array_sizes[] = $size->id;
                    }
                }




                // $array_qty=implode('')
                // dd($array_colors);
                // ColorSizeProduct::query()->where('product_id',$product->id)->delete();
                // foreach ($array_colors as $key => $value) {
                    foreach ($array_sizes as $keyy=>$size_value) {

                        $quantity=0;

                        $intarray=   explode(',', $row['quantity_size_color']);


                     foreach($intarray as $value_qty){
                        $quantity+=$value_qty;

                     }

                     $color=Color::query()->where('name', 'like', '%' . $row['colors'] . '%')->first();



                    //  if($color){


                   $product_color_sizes= ColorSizeProduct::query()->updateOrCreate([
                            'product_id'=>$product->id,
                            'color_id'=>$color->id,
                            'size_id'=>$size_value,
                   ],[
                            'quantity'=>$intarray[$keyy]

                        ]);

                    // }
                    // }
                }
                $product->update([
                    'quantity' => $quantity,
                    'available_quantity' => $quantity,

                ]);
            }
    }

    public function rules(): array
    {
        // TODO: Implement rules() method.

        return [
//            '*.product_name' => ['required', 'max:50', 'distinct', 'unique:products,name,'.auth('admin')->user()->id],


        ];

    }

    public function batchSize(): int
    {
        return 10000;
    }

    public function chunkSize(): int
    {
        return 10000;
    }


    public function slug($string, $separator = '-')
    {
        if (is_null($string)) {
            return "";
        }

        $string = trim($string);

        $string = mb_strtolower($string, "UTF-8");;

        $string = preg_replace("/[^a-z0-9_\sءاأإآؤئبتثجحخدذرزسشصضطظعغفقكلمنهويةى]#u/", "", $string);

        $string = preg_replace("/[\s-]+/", " ", $string);

        $string = preg_replace("/[\s_]/", $separator, $string);

        return $string;
    }

//    public function uniqueBy()
//    {
//        return 'name';
//    }

}
