<?php

namespace App\Imports;

use App\Models\Answer;
use App\Models\Question;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class QuestionImport implements ToCollection, WithHeadingRow
{
    public $lessonId;

    public function __construct($lessonId)
    {
        $this->lessonId = $lessonId;
    }

    public function collection(Collection $rows)
    {
        foreach ($rows as $row) {
            // Collect all answers in an array
            $answers = [
                ['answer' => $row['correct_answer'], 'is_correct' => 1], // Correct answer
                ['answer' => $row['wrong_answer_1'], 'is_correct' => 0],
                ['answer' => $row['wrong_answer_2'], 'is_correct' => 0],
                ['answer' => $row['wrong_answer_3'], 'is_correct' => 0],
            ];

            // Shuffle the answers array
            shuffle($answers);

            // Create the question
            $question = Question::query()->create([
                'questions' => $row['question'], // Ensure 'question' is present in your Excel headers
                'lesson_id' => $this->lessonId,

            ]);

            // Insert shuffled answers into the database
            foreach ($answers as $answer) {
             $answer=   Answer::query()->create([
                    'question_id' => $question->id,
                    'answer' => $answer['answer'],
                    'is_correct' => $answer['is_correct'],
                ]);

                if($answer['is_correct'])
                $question->update([
                    'is_correct'=>$answer->id,
                ]);

            }
        }
    }
}
