<?php

namespace App\Imports;

use App\Models\School;
use App\Models\EducationalArea;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Concerns\SkipsErrors;
use Maatwebsite\Excel\Concerns\SkipsFailures;
use Maatwebsite\Excel\Concerns\SkipsOnError;
use Maatwebsite\Excel\Concerns\SkipsOnFailure;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;

class SchoolsImport implements  ToModel, WithValidation, WithHeadingRow, SkipsOnError, SkipsOnFailure
{
    use SkipsErrors, SkipsFailures;

    public $failedRows = []; // Array to store failed rows

    protected $errors = []; // Store row-level errors


    protected $attributeToColumnMap = [
        'education_area_name' => 'Education Area Name',
        'school_name' => 'School Name',
    ];
    public function model(array $row)
    {
        $educationalArea = EducationalArea::query()->where('name', $row['education_area_name'])->first();

        if (!$educationalArea) {
            $this->errors[] = [
                'row' => $row,
                'values' => $row,
                'errors' => ["Educational Area not found: " . $row['education_area_name']]
            ];
            return null; // Skip processing this row
        }

        return new School([
            'name' => $row['school_name'],
            'educational_area_id' => $educationalArea->id
        ]);
    }
    public function rules(): array
    {
        return [


            'school_name' => ['required', function ($attribute, $value, $fail) {
                if (School::query()->where('name', $value)->exists()) {
                    $fail("The school '{$value}'  exist.");
                }
            }],
            // 'educational_area_name' => ['required', function ($attribute, $value, $fail) {
            //     if (!EducationalArea::query()->where('name', $value)->exists()) {
            //         $fail("The  '{$value}' does not exist.");
            //     }
            // }],
        ];
    }

    public function onFailure(\Maatwebsite\Excel\Validators\Failure ...$failures)
    {
        foreach ($failures as $failure) {
            $rowIndex = $failure->row();

            if (!isset($this->errors[$rowIndex])) {
                $this->errors[$rowIndex] = [
                    'row' => $rowIndex,
                    'values' => $failure->values(),
                    'errors' => []
                ];
            }

            foreach ($failure->errors() as $field => $error) {
                if (!in_array($error, $this->errors[$rowIndex]['errors'])) {
                    $this->errors[$rowIndex]['errors'][] = $error;
                }
            }
        }
    }

    public function getErrors()
    {
        return $this->errors;
    }
}
