<?php

namespace App\Imports;

use App\Models\ClassRoom;
use App\Models\EducationalArea;
use App\Models\Governorate;
use App\Models\School;
use App\Models\Student;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class StudentImport implements ToCollection, WithHeadingRow
{
    use Importable;

    public function collection(Collection $rows)
    {
        ini_set('max_execution_time', 300); // 300 seconds = 5 minutes


        foreach ($rows as $row) {

            $governorate = Governorate::firstOrCreate(
                ['name' => $row['governorate_name']],
                ['name' => $row['governorate_name']] // Additional fields if necessary
            );
            $educationalArea = EducationalArea::firstOrCreate(
                ['name' => $row['educational_area_name']],
                ['name' => $row['educational_area_name'],
                    'governorate_id'=>$governorate->id
                    ],

            // Additional fields if necessary
            );
            $school = School::firstOrCreate(
                ['name' => $row['school_name']],
                ['name' => $row['school_name'],
                    'educational_area_id'=>$educationalArea->id
                    ] // Additional fields if necessary

            );

            $classRooms = ClassRoom::firstOrCreate(
                ['name' => $row['class_room_name']],
                ['name' => $row['class_room_name'],
                    'code'=>$row['class_room_name']] // Additional fields if necessary

            );

            // Now, update or create the Student record
            Student::updateOrCreate(
                [
                    'id_number' => $row['id_number'] // Unique field
                ],
                [
                    'mobile' => $row['mobile'],
                    'name'=>$row['name'],
                    'school_id' => $school->id,
                    'governorate_id' => $governorate->id,
                    'class_room_id'=>$classRooms->id,
                    'educational_area_id' => $educationalArea->id,

                ]
                );
            }
        }


}
