<?php

namespace App\Livewire\Chapters;

use App\Models\Chapter;
use App\Models\ClassRoom;
use App\Models\Lesson;
use App\Models\Material;
use Livewire\Component;
use Livewire\WithFileUploads;
use Livewire\WithPagination;

class ChapterComponent extends Component
{
    use WithFileUploads, WithPagination;

    public $search_material_id=null;
    public $isModalOpen = false;
    public $isLessonModalOpen = false;
    public $isDeleteConfirmationOpen = false;
    public $isAddLessonModalOpen = false;
    public $isDeleteLessonConfirmationOpen = false;
    public $isEditLessonModalOpen = false;
    public $perPage=10;

    public  $serach_materials=[];
    public $name, $status = 1, $title, $description, $classRoomId, $materialId, $chapterId,$edit_lesson_name,$edit_lesson_description;
    public $lesson_name, $lesson_description, $attachment, $cover_attachment, $lessons = [];
    public $search = '';
    public $sortField = 'name';
    public $sortDirection = 'asc';
    public $materials = [];
    public $progress = 0;
    public $lessonId;
    public $existingVideoPath; // For the existing video path
    public $existingCoverPath;
    public  $lesson_code; // For the existing cover image path


    protected $listeners = ['fileUploadProgress'];

    public function fileUploadProgress($progress)
    {
        $this->progress = $progress;
    }



    public function openModal($id = null)
    {
        $this->reset(['name', 'status', 'description', 'title', 'classRoomId', 'materialId', 'chapterId']);
        $this->isModalOpen = true;

        $this->classRoomId = $this->search_class_room_id;
        $this->materialId = $this->search_material_id;
        $this->materials = Material::query()->where('class_room_id', $this->search_class_room_id)->get();

        if ($id) {
            $chapter = Chapter::findOrFail($id);
            $this->fillChapter($chapter);
        }
    }

    public function fillChapter($chapter)
    {
        $this->chapterId = $chapter->id;
        $this->name = $chapter->name;
        $this->title=$chapter->title;
        $this->description = $chapter->description;
        $this->classRoomId = $chapter->class_room_id;
        $this->materialId = $chapter->material_id;
        $this->status = $chapter->status;
        $this->materials = Material::where('class_room_id', $this->classRoomId)->get();
    }

    public function closeModal()
    {
        $this->isModalOpen = false;
    }

    public function save()
    {
//        $validatedData = $this->validateChapter();
        $this->validate([
            'name' => 'required|string|max:255',
            'classRoomId' => 'required|exists:class_rooms,id',
            'materialId' => 'required|exists:materials,id',
            'title' => 'required|string|max:255',
            'description' => 'required|string|max:255',
        ]);
        Chapter::updateOrCreate(
            ['id' => $this->chapterId],

                 ['name'=>$this->name,
                 'title'=>$this->title,
                 'description'=>$this->description,
                 'material_id'=>$this->materialId,
                 'class_room_id'=>$this->classRoomId,
                 'status' => $this->status ? 1 : 0]
        );

        $this->closeModal();
        $this->dispatch('success', ['message' => 'تم تنفيد العملية بنجاح']);
    }


    public  function  closeOpenLesson(){
        $this->isLessonModalOpen=false;
    }


    public function confirmDelete($id)
    {
        $this->chapterId = $id;
        $this->isDeleteConfirmationOpen = true;
    }

    public function closeDeleteConfirmation()
    {
        $this->isDeleteConfirmationOpen = false;
    }

    public function deleteConfirmed()
    {
        Chapter::findOrFail($this->chapterId)->delete();
        $this->closeDeleteConfirmation();
        $this->dispatch('success', ['message' => 'تم تنفيد العملية بنجاح']);
    }

    public function confirmLessonDelete($id)
    {
        $this->lessonId = $id;
        $this->isDeleteLessonConfirmationOpen = true;
    }

    public function closeDeleteLessonConfirmation()
    {
        $this->isDeleteLessonConfirmationOpen = false;
    }

    public function deleteLessonConfirmed()
    {
        Lesson::findOrFail($this->lessonId)->delete();
        $this->closeDeleteLessonConfirmation();
        $this->refreshLessons();
        $this->dispatch('success', ['message' => 'تم تنفيد العملية بنجاح']);
    }

    public function refreshLessons()
    {
        $this->lessons = Lesson::where('chapter_id', $this->chapterId)->get();
    }

    public function openModalLesson($id = null)
    {
        $this->isLessonModalOpen = true;

        if ($id) {
            $chapter = Chapter::findOrFail($id);
            $this->fillChapter($chapter);
            $this->refreshLessons();
        }
    }

    public function openModalAddLesson($id = null)
    {
        $this->reset(['lesson_name', 'lesson_description', 'materialId', 'attachment', 'cover_attachment','lesson_code']);
        $this->isAddLessonModalOpen = true;

        if ($id) {
            $chapter = Chapter::findOrFail($id);
            $this->fillChapter($chapter);
        }
    }

    public function saveLesson()
    {

        $this->validate([
            'lesson_name' => 'required|string|max:255',
            'lesson_description' => 'required|string|max:500',
//            'attachment' => 'required|max:255', // Example for video file
            'lesson_code'=>'required'// Example for image file
            ]);

        if ($this->attachment) {

            $materials=Material::query()->find($this->materialId);
            $classRoom=$materials->classRooms?$materials->classRooms->code:'';
            $chapter=Chapter::query()->find($this->chapterId);

            $this->attachmentPath=$this->attachment;

        }



        // Save lesson logic here
        Lesson::create([
            'name' => $this->lesson_name,
            'description' => $this->lesson_description,
            'chapter_id' => $this->chapterId,
            'material_id' => $this->materialId,
            'attachment' => $this->attachmentPath ?? null,
            'cover_attachment' => $this->coverAttachmentPath ?? null,
            'code'=>$this->lesson_code,
//            'class_room_id'=>$this->classRoomId,
        ]);


        $this->closeAddLessonModal();
        $this->refreshLessons();
        $this->reset(['attachment', 'cover_attachment']);

        $this->dispatch('upload-finished');
        $this->dispatch('success', ['message' => 'تم تنفيذ العملية بنجاح']);
    }

    public function closeLessonModal()
    {
        $this->isLessonModalOpen = false;
    }

    public function closeAddLessonModal()
    {
        $this->isAddLessonModalOpen = false;
    }

    public function openEditLessonModal($id = null)
    {
        $this->reset(['lesson_name', 'lesson_description', 'chapterId', 'materialId', 'attachment', 'cover_attachment']);
        $this->isEditLessonModalOpen = true;

        if ($id) {
            $lesson = Lesson::findOrFail($id);
            if ($lesson) {
                $this->edit_lesson_name = $lesson->name;
                $this->edit_lesson_description = $lesson->description;

                $this->existingVideoPath = $lesson->attachment; // Set the existing video path
              $this->existingCoverPath = $lesson->cover_attachment; // Set the existing cover image path

                $this->lessonId = $lesson->id;
            }
        }
    }

    public function updateLesson()
    {

        $this->validate([
            'edit_lesson_name' => 'required|string|max:255',
            'edit_lesson_description' => 'required|string|max:500',
            'attachment' => 'nullable|file|mimes:mp4,mkv,avi', // Example for video file
            'cover_attachment' => 'nullable|image|mimes:jpeg,png,jpg', // Example for image file
            ]);
        $lesson = Lesson::findOrFail($this->lessonId);
        $lesson->update([
            'name' => $this->edit_lesson_name,
            'description' => $this->edit_lesson_description,
            'attachment' => $this->attachment,
            'cover_attachment' => $this->cover_attachment,
        ]);

        $this->closeEditLessonModal();
        $this->dispatch('success', ['message' => 'تم تنفيد العملية بنجاح']);
    }

    public function closeEditLessonModal()
    {
        $this->isEditLessonModalOpen = false; // Corrected
    }

    public function onClassRoomChange()
    {
        $this->search_material_id=null;
        $this->materials = Material::where('class_room_id', $this->classRoomId)->get();

        if (!Material::where('class_room_id', $this->classRoomId)->where('id', $this->materialId)->exists()) {
            $this->materialId = null;
        }
    }
    public $search_class_room_id;
    public $search_materials = [];

    public function updatedSearchClassRoomId($value)
    {
        $this->fetchMaterials($value);
    }



    public function fetchMaterials($classRoomId)
    {
        $this->search_materials = Material::where('class_room_id', $classRoomId)->get();
    }

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function sortBy($field)
    {
        $this->sortDirection = $this->sortField === $field
            ? ($this->sortDirection === 'asc' ? 'desc' : 'asc')
            : 'asc';
        $this->sortField = $field;
    }

    public function render()
    {

        $classRooms = ClassRoom::active()->get();
        $chapters = Chapter::query()
            ->when($this->search, function ($query) {
                $query->where('name', 'like', '%' . $this->search . '%')
                    ->orWhere('title', 'like', '%' . $this->search . '%');
            })
            ->when($this->search_class_room_id,function($q){
                    $q->where('class_room_id',$this->search_class_room_id);
            })
            ->when($this->search_material_id,function($q){
                $q->where('material_id',$this->search_material_id);
            })


             ->orderBy('class_room_id','desc')
            ->orderBy($this->sortField, $this->sortDirection)
            ->paginate($this->perPage);
        return view('livewire.chapters.chapter-component', [
            'classRooms' => $classRooms,
            'chapters' => $chapters,
        ])->layout('layouts.admin.master');
    }
}
