<?php

namespace App\Livewire\ClassPeriods;

use App\Models\Admin;
use App\Models\ClassPeriod;
use App\Models\ClassRoom;
use App\Models\ClassSection;
use App\Models\Lab;
use App\Models\Material;
use Livewire\Component;
use Livewire\WithPagination;

class ClassPeriodComponent extends Component
{
    use WithPagination;

    public $class_room_id, $class_section_id, $teacher_id, $date, $start_time,$material_id, $end_time, $status, $classPeriodId,$search_class_room_id;
    public $isModalOpen = false,$lab_id, $isDeleteConfirmationOpen = false, $search = '';
    public $classSections = [];

    public  $materials=[];
    protected $rules = [
        'class_room_id' => 'required|exists:class_rooms,id',
        'class_section_id' => 'required|exists:class_sections,id',
        'material_id'=>'required|exists:materials,id',
        'lab_id'=>'required|exists:labs,id',

        'teacher_id' => 'required|exists:admins,id',
        'date' => 'required|date',
        'start_time' => 'required|date_format:H:i',
        'end_time' => 'required|date_format:H:i|after:start_time',
    ];

    // Load sections based on selected class room
    public function onClassRoomChange()
    {
        $this->classSections = ClassSection::where('class_room_id', $this->class_room_id)->get();
        $this->materials = Material::where('class_room_id', $this->class_room_id)->get();
        $this->class_section_id = null;  // Reset the section on class room change
    }
    public function onSearchClassRoomChange()
    {
        $this->classSections = ClassSection::where('class_room_id', $this->search_class_room_id)->get();
        $this->materials = Material::where('class_room_id', $this->search_class_room_id)->get();
        $this->class_section_id = null;  // Reset the section on class room change
    }



    // Render the class periods with applied filters
    public function render()
    {
        $classPeriods = ClassPeriod::query()
            ->when($this->search_class_room_id, fn($query) => $query->where('class_room_id', $this->search_class_room_id))
            ->when($this->class_section_id, fn($query) => $query->where('class_section_id', $this->class_section_id))
            ->when($this->material_id, fn($query) => $query->where('material_id', $this->material_id))
            ->when($this->date, fn($query) => $query->where('date', $this->date))
            ->when($this->lab_id, fn($query) => $query->where('lab_id', $this->lab_id))

            ->when($this->teacher_id, fn($query) => $query->where('teacher_id', $this->teacher_id))
            ->when($this->search, function ($query) {
                return $query->whereHas('teachers', fn($q) => $q->where('name', 'like', '%' . $this->search . '%'))
                    ->orWhereHas('classSections', fn($q) => $q->where('name', 'like', '%' . $this->search . '%'));
            })
            ->paginate(10);

        $classRooms = ClassRoom::all();
        $teachers = Admin::all();
        $labs = Lab::all();

        return view('livewire.class-periods.class-period-compnent', [
            'classPeriods' => $classPeriods,
            'classRooms' => $classRooms,
            'teachers' => $teachers,
            'labs'=>$labs,
        ])->layout('layouts.admin.master');
    }

    // Open the modal to create or edit class period
    public function openModal($id = null)
    {
        $this->resetValidation();
        $this->classPeriodId = $id;

        if ($id) {
            $this->loadClassPeriodData($id);
        } else {
            $this->reset();
        }

        $this->isModalOpen = true;
    }

    // Close the modal and reset the form
    public function closeModal()
    {
        $this->reset();
        $this->isModalOpen = false;
    }

    // Load the class period data for editing
    private function loadClassPeriodData($id)
    {
        $classPeriod = ClassPeriod::findOrFail($id);
        $this->class_room_id = $classPeriod->class_room_id;
        $this->class_section_id = $classPeriod->class_section_id;
        $this->teacher_id = $classPeriod->teacher_id;
        $this->material_id = $classPeriod->material_id;
        $this->lab_id = $classPeriod->lab_id;

        $this->date = $classPeriod->date;
        $this->start_time = $classPeriod->start_time;
        $this->end_time = $classPeriod->end_time;
        $this->classSections = ClassSection::query()->where('class_room_id',$classPeriod->class_room_id)->get();


//        $this->onClassRoomChange();


    }

    // Save or update the class period data
    public function save()
    {
        $this->validate();

        try {
            ClassPeriod::updateOrCreate(
                ['id' => $this->classPeriodId],
                [
                    'class_room_id' => $this->class_room_id,
                    'class_section_id' => $this->class_section_id,
                    'teacher_id' => $this->teacher_id,
                    'date' => $this->date,
                    'start_time' => $this->start_time,
                    'end_time' => $this->end_time,
                    'lab_id'=>$this->lab_id,
                    'material_id'=>$this->material_id
                ]
            );

            $this->dispatch('success', ['message' => 'تم تنفيذ العملية بنجاح']);
            $this->closeModal();
        } catch (\Exception $e) {
            $this->dispatch('error', ['message' => 'حدث خطأ أثناء حفظ البيانات']);
        }
    }

    // Confirm the deletion of a class period
    public function confirmDelete($id)
    {
        $this->classPeriodId = $id;
        $this->isDeleteConfirmationOpen = true;
    }

    // Close the delete confirmation modal
    public function closeDeleteConfirmation()
    {
        $this->isDeleteConfirmationOpen = false;
    }

    // Delete the class period after confirmation
    public function deleteConfirmed()
    {
        try {
            ClassPeriod::find($this->classPeriodId)->delete();
            $this->dispatch('success', ['message' => 'تم حذف البيانات بنجاح']);
            $this->closeDeleteConfirmation();
        } catch (\Exception $e) {
            $this->dispatch('error', ['message' => 'حدث خطأ أثناء حذف البيانات']);
        }
    }
}
