<?php

namespace App\Livewire\ClasssRooms;

use App\Models\ClassRoom;
use App\Models\Material;
use Livewire\Component;
use Livewire\WithFileUploads;
use Livewire\WithPagination;

class ClassRoomComponent extends Component
{

    use WithPagination;
    use WithFileUploads;
    public $isModalOpen = false;
    public $isDeleteConfirmationOpen = false;
    public  $classRoomName,$code,$materialId,$attachment,$name, $status=1,$classRoomId,$search='',$search_material='',$perPage=10;
    public $sortField = 'name';
    public $sortDirection = 'asc';
    public  $materials=[];
    public  $isMaterails=false;
    public  $isMaterialModalOpen=false;
    public  $isdisplayMaterialModalOpen=false;
    public function openModal($id = null)
    {
        $this->reset(['name','code', 'status', 'classRoomId']);
        $this->isModalOpen = true;

        if ($id) {
            $classRoom = ClassRoom::findOrFail($id);
            $this->classRoomId = $classRoom->id;
            $this->name = $classRoom->name;
            $this->code = $classRoom->code;

            $this->status = $classRoom->status;
        }
    }

    public function closeModal()
    {
        $this->isModalOpen = false;
    }

    public function save()
    {

        $this->validate([
            'name' => 'required',
            'code' => 'required',

        ]);
        ClassRoom::query()->updateOrCreate(
            ['id' => $this->classRoomId],
            [
                'name' => $this->name,
                'code'=>$this->code,
                'status' => $this->status ? 1 : 0,
            ]
        );

        $this->closeModal();
        $this->dispatch('success', ['message' => 'تم تنفيد العملية بنجاح']);

    }

    public function confirmDelete($id)
    {
        $this->classRoomId = $id;
        $this->isDeleteConfirmationOpen = true;
    }

    public function closeDeleteConfirmation()
    {
        $this->isDeleteConfirmationOpen = false;
    }

    public function deleteConfirmed()
    {
        ClassRoom::findOrFail($this->classRoomId)->delete();

        $this->closeDeleteConfirmation();
        $this->dispatch('success', ['message' => 'تم تنفيد العملية بنجاح']);

        // session()->flash('message', 'Governorate deleted successfully.');
    }

    public function updatingSearch()
    {
        $this->resetPage();
    }


    public function updatingSearchMaterial()
    {
        $this->resetPage();
    }

    public function sortBy($field)
    {
        $this->sortDirection = $this->sortField === $field ? ($this->sortDirection === 'asc' ? 'desc' : 'asc') : 'asc';
        $this->sortField = $field;
    }




    public function render()
    {

        $classroom = ClassRoom::query()
            ->where('name', 'like', '%' . $this->search . '%')
            ->orderBy($this->sortField, $this->sortDirection)
            ->paginate($this->perPage);


        return view('livewire.classs-rooms.class-room-component', [
            'classrooms'=>$classroom,


        ])->layout('layouts.admin.master');
    }



    public function openModalMaterial($id = null)
    {
        $this->reset(['materials', 'classRoomId']);
        $this->isMaterialModalOpen = true;

        if ($id) {

            $this->classRoomId = $id;
            $this->materials = [];

            $classRoom=ClassRoom::query()->where('id',$id)->first();
            $this->classRoomName=$classRoom->name;
//            $material = Material::findOrFail($id);
//            $this->classRoomId = $material->class_room_id;
//            $this->name = $material->name;
//            $this->status = $material->status;
//            $this->materialId = $material->id;
            if (empty($this->materials)) {
                $this->materials  = [
                    [
                        'name' => '', // Default empty name
                        'classRoomId' => $this->classRoomId,
                        'attachment' => $this->attachment,

//                        'is_correct' => $this->is_correct,
                    ]
                ];
            }
        }

    }

    public function openModalShowMaterial($id = null)
    {
        $this->reset(['materials', 'classRoomId']);
        $this->isdisplayMaterialModalOpen = true;

        if ($id) {

            $this->classRoomId = $id;
            $this->materials = [];

            $classRoom=ClassRoom::query()->where('id',$id)->first();
            $this->classRoomName=$classRoom->name;

            $this->materials=Material::query()
                ->where('name','like','%'.$this->search_material.'%')
                ->where('class_room_id',$classRoom->id)->get();
//            if (empty($this->materials)) {
//                $this->materials  = [
//                    [
//                        'name' => '', // Default empty name
//                        'classRoomId' => $this->classRoomId,
//                        'attachment' => $this->attachment,
//
////                        'is_correct' => $this->is_correct,
//                    ]
//                ];
//            }
        }

    }

    public  function closeDisplayMaterialModal(){
        $this->isdisplayMaterialModalOpen = false;

    }

    // Save chapter details


    public function saveMaterials()
    {

//        $this->validate(app(MuteMaterialRequest::class)->rules());
        $this->validate([
            'materials' => 'required|array',
            'materials.*.name' => 'required|string',
            'materials.*.code' => 'required|string',

            'materials.*.attachment' => 'required|mimes:jpg,png|max:102400', // Adjust validation rules as needed
        ]);

        foreach ($this->materials as $material) {
            $materialData = [
                'name' => $material['name'],
                'code' => $material['code'],

                'class_room_id' => $this->classRoomId,
            ];
            $classRoom=ClassRoom::query()->find($this->classRoomId);
            $destinationPath = $classRoom->code . '/' . $material['code'] . '/materials/'; // Append the file name only
            $materialData['attachment']=$material['attachment']->store($destinationPath, 'public');
        Material::create($materialData);
    }


        $this->closeMaterialModal();
        $this->dispatch('success', ['message' => 'تم تنفيذ العملية بنجاح']);

    }

    public function addMaterialRow()
    {
        $this->materials[] = ['name' => '', 'attachment' => '', 'classRoomId' => $this->classRoomId];
    }

    // Remove chapter row by index
    public function removeMaterialRow($index)
    {
        unset($this->materials[$index]);
        $this->materials = array_values($this->materials); // Re-index the array
    }

    public function closeMaterialModal()
    {
        $this->isMaterialModalOpen = false;
    }




}
