<?php
namespace App\Livewire\Dashboard;

use App\Models\ClassRoom;
use App\Models\Material;
use App\Models\Student;
use Carbon\Carbon;
use Illuminate\Support\Facades\Storage;
use Livewire\Component;
use Livewire\WithPagination;

class DashboardComponent extends Component
{
    use WithPagination;

    public $totalStudents;
public $activeStudents;
public $inactiveStudents;
public $lastStudent;
public $marksCount;
public $studentsWithLessons;
public $averageLessonsWatched;
public $averageLessonsMark;
public $rateLessonWatchChange;
public $storageUsage;

public $currentMonthAverage;
public $previousMonthAverage;
public $badgeClass;

public  $class_room_id='';
    public  $search='';

    protected $listeners = ['loginSuccess' => 'handleLoginSuccess'];

    public function handleLoginSuccess()
    {
        return redirect()->route('index');
    }
    public function mount()
{

    //total_student

    $current_month_student=Student::query()->whereMonth('created_at', Carbon::now()->month)
        ->whereYear('created_at', Carbon::now()->year)->count();
    $previous_month_student=Student::query()->whereMonth('created_at', Carbon::now()->subMonth())
        ->whereYear('created_at', Carbon::now()->year)->count();

    $this->totalStudents = Student::query()->count();
$this->activeStudents = Student::query()->where('is_active', 1)->count();
$this->inactiveStudents = Student::query()->where('is_active', 0)->count();
$this->storageUsage = $this->calculateStorageUsage();

//$this->studentsWithLessons = Student::with('watchLessons')->get();
$this->averageLessonsWatched = Student::averageLessonsWatchedByAllStudents();
$this->averageLessonsMark = Student::averageMarksForAllStudents();
$this->rateLessonWatchChange = Student::averageLessonsWatchedRate();

// Get monthly averages
$this->currentMonthAverage = Student::averageLessonsWatchedForCurrentMonth();
$this->setBadgeClass();
}

public function calculateStorageUsage()
{
$totalSize = 0;

// Get all files in the public storage
$files = Storage::allFiles('public');

foreach ($files as $file) {
$totalSize += Storage::size($file);
}

// Convert size to megabytes
return round($totalSize / 1024 / 1024, 0); // MB
}

public function setBadgeClass()
{
// Determine if current month's average is greater than previous month's average
if ($this->currentMonthAverage > $this->previousMonthAverage) {
$this->badgeClass = 'badge badge-success fs-base';
} else {
$this->badgeClass = 'badge badge-danger fs-base';
}
}

public function render()
{
return view('livewire.dashboard.dashboard-component', [
'students' => Student::query()
    ->when($this->class_room_id,function ($q){
        $q   ->where('class_room_id', 'like', '%' . $this->class_room_id . '%');

    })
    ->when($this->search,function ($q){
        $q->where('name', 'like', '%' . $this->search . '%')->orWhere('id_number','like', '%' . $this->search . '%');


    })


    ->paginate(6),
'classRooms'=>ClassRoom::query()->get(),
'averageLessonsWatched' => $this->averageLessonsWatched,
'currentMonthAverage' => $this->currentMonthAverage,
'previousMonthAverage' => $this->previousMonthAverage,
'badgeClass' => $this->badgeClass,
    'materials'=>Material::query()
        ->whereHas('lessons',function ($q){
//            $q->wherehas('watchLessons');
        })
        ->get(),
])->layout('layouts.admin.master');
}
}
