<?php

namespace App\Livewire\EducationArea;

use App\Models\EducationalArea;
use App\Models\Governorate;
use Livewire\Component;
use Livewire\WithPagination;

class EducationalAreaComponent extends Component
{

    use WithPagination;
    public $isModalOpen = false;
    public $isDeleteConfirmationOpen = false;
    public $name, $status=1, $governorateId,$educationalAreaId,$educational_areas_id,$perPage = 10; // Pagination limit
    public $search = '';
    public $sortField = 'name';
    public $sortDirection = 'asc';
    protected $rules = [
        'name' => 'required|string|max:255',
        'governorateId'=>'required|exists:governorates,id'
    ];


    protected $messages = [
        'name.required' => 'الاسم مطلوب.',
        'name.string'   => 'الاسم يجب ان يكون نصا.',
        'name.max'      => 'يجب ان يكون حجم النص اقل من 255 حرف.',
        'governorateId.required'=>'المحافظة مطلوبة',
        'governorateId.exists'=>'المحافظة غير موجودة',
    ];

    public function openModal($id = null)
    {
        $this->reset(['name', 'status', 'governorateId','educationalAreaId']);
        $this->isModalOpen = true;

        if ($id) {
            $educationalArea = EducationalArea::findOrFail($id);
            $this->governorateId = $educationalArea->governorate_id;
            $this->name = $educationalArea->name;
            $this->status = $educationalArea->status;
            $this->educationalAreaId = $educationalArea->id;

        }
    }

    public function closeModal()
    {
        $this->isModalOpen = false;
    }

    public function save()
    {
        $this->validate();
        EducationalArea::updateOrCreate(
            ['id' => $this->educationalAreaId],
            [
                'name' => $this->name,
                'governorate_id' => $this->governorateId,

                'status' => $this->status ? 1 : 0,
            ]
        );
        $this->closeModal();
        $this->dispatch('success', ['message' => 'تم تنفيد العملية بنجاح']);
    }

    public function confirmDelete($id)
    {
        $this->educationalAreaId = $id;
        $this->isDeleteConfirmationOpen = true;
    }

    public function closeDeleteConfirmation()
    {
        $this->isDeleteConfirmationOpen = false;
    }

    public function deleteConfirmed()
    {
        EducationalArea::findOrFail($this->educationalAreaId)->delete();
        $this->closeDeleteConfirmation();
        $this->dispatch('success', ['message' => 'تم تنفيد العملية بنجاح']);
    }

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function sortBy($field)
    {
        $this->sortDirection = $this->sortField === $field ? ($this->sortDirection === 'asc' ? 'desc' : 'asc') : 'asc';
        $this->sortField = $field;
    }

    public function render()
    {
        $governorates = Governorate::query()
            ->active()
            ->get();

        $educational_areas_id=$this->educational_areas_id;
        $educationalAreas = EducationalArea::query()
            ->when($educational_areas_id,function ($q)use ($educational_areas_id){
                $q->where('governorate_id',$educational_areas_id);
            })

            ->where('name', 'like', "%{$this->search}%")

            ->orderBy($this->sortField, $this->sortDirection)
            ->paginate($this->perPage);

        return view('livewire.education-area.educational-area-component', [
            'governorates' => $governorates,
            'educationalAreas' => $educationalAreas,

        ])->layout('layouts.admin.master');
    }

}
